/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.postag;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.params.FineGrainedEvaluatorParams;
import opennlp.tools.cmdline.postag.POSEvaluationErrorListener;
import opennlp.tools.cmdline.postag.POSTaggerFineGrainedReportListener;
import opennlp.tools.cmdline.postag.TrainingParams;
import opennlp.tools.postag.POSSample;
import opennlp.tools.postag.POSTaggerCrossValidator;
import opennlp.tools.util.model.ModelUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class POSTaggerCrossValidatorTool
extends AbstractCrossValidatorTool<POSSample, CVToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(POSTaggerCrossValidatorTool.class);

    public POSTaggerCrossValidatorTool() {
        super(POSSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable POS tagger";
    }

    @Override
    public void run(String format, String[] args2) {
        POSTaggerCrossValidator validator;
        Map<String, Object> resources;
        super.run(format, args2);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createDefaultTrainingParameters();
        }
        POSEvaluationErrorListener missclassifiedListener = null;
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            missclassifiedListener = new POSEvaluationErrorListener();
        }
        POSTaggerFineGrainedReportListener reportListener = null;
        File reportFile = ((CVToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile("Report Output File", reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new POSTaggerFineGrainedReportListener(reportOutputStream);
            }
            catch (FileNotFoundException e) {
                throw this.createTerminationIOException(e);
            }
        }
        try {
            resources = TokenNameFinderTrainerTool.loadResources(((CVToolParams)this.params).getResources(), ((CVToolParams)this.params).getFeaturegen());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while loading resources", e);
        }
        byte[] featureGeneratorBytes = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(((CVToolParams)this.params).getFeaturegen());
        try {
            validator = new POSTaggerCrossValidator(((CVToolParams)this.params).getLang(), this.mlParams, ((CVToolParams)this.params).getDict(), featureGeneratorBytes, resources, ((CVToolParams)this.params).getTagDictCutoff(), ((CVToolParams)this.params).getFactory(), missclassifiedListener, reportListener);
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        logger.info("done");
        if (reportListener != null) {
            logger.info("Writing fine-grained report to {}", (Object)((CVToolParams)this.params).getReportOutputFile().getAbsolutePath());
            reportListener.writeReport();
            try {
                ((OutputStream)reportOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        logger.info("Accuracy: {}", (Object)validator.getWordAccuracy());
    }

    static interface CVToolParams
    extends CVParams,
    TrainingParams,
    FineGrainedEvaluatorParams {
    }
}

