/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.jaxp;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.jaxp.TypedContentHandler;
import com.saxonica.ee.jaxp.ValidatorHandlerImpl;
import com.saxonica.ee.jaxp.ValidatorImpl;
import com.saxonica.ee.schema.PreparedSchema;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.validation.ValidatorHandler;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.s9api.HostLanguage;
import org.xml.sax.helpers.XMLFilterImpl;

public class SchemaReference
extends Schema {
    private final PreparedSchema schema;

    public SchemaReference(PreparedSchema schema) {
        this.schema = schema;
    }

    public PreparedSchema getPreparedSchema() {
        return this.schema;
    }

    @Override
    public Validator newValidator() {
        PipelineConfiguration pipe = this.schema.getConfiguration().makePipelineConfiguration();
        pipe.setHostLanguage(HostLanguage.XML_SCHEMA);
        return new ValidatorImpl(pipe, this.schema);
    }

    @Override
    public ValidatorHandler newValidatorHandler() {
        EnterpriseConfiguration config = this.schema.getConfiguration();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        pipe.setHostLanguage(HostLanguage.XML_SCHEMA);
        TypedContentHandler proxy = new TypedContentHandler(new XMLFilterImpl());
        proxy.setPipelineConfiguration(pipe);
        ParseOptions options = new ParseOptions().withSchemaValidationMode(1).withSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance()).withCheckEntityReferences(true);
        pipe.setParseOptions(options);
        pipe.setRecoverFromValidationErrors(true);
        Receiver realValidator = config.getDocumentValidator(proxy, proxy.getSystemId(), options, null);
        ReceivingContentHandler rch = new ReceivingContentHandler();
        rch.setReceiver(realValidator);
        rch.setPipelineConfiguration(pipe);
        ValidatorHandlerImpl val = new ValidatorHandlerImpl();
        val.setPipelineConfiguration(pipe);
        val.setReceivingContentHandler(rch);
        val.setFinalProxy(proxy);
        return val;
    }
}

