/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.feed.ItemFeed;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;

public class CallableFeed
extends ItemFeed {
    Callable function;
    Expression[] arguments;
    boolean done = false;

    public CallableFeed(Callable function, ItemFeed result, XPathContext context, Expression[] arguments) {
        super(result, context);
        this.function = function;
        this.arguments = arguments;
    }

    @Override
    public void append(Item item) throws XPathException {
        if (!this.hasFailed()) {
            if (this.done) {
                StructuredQName fName;
                String msg = "A sequence of more than one item must not be supplied as the streaming argument";
                if (this.function instanceof FunctionItem && (fName = ((FunctionItem)this.function).getFunctionName()) != null) {
                    msg = msg + " of function " + fName.getDisplayName();
                }
                Loc loc = this.getExpression() == null ? Loc.NONE : this.getExpression().getLocation();
                throw new XPathException(msg, "XPTY0004", loc);
            }
            this.doCall(item);
            this.done = true;
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            if (!this.done) {
                this.doCall(null);
            }
            super.close();
        }
    }

    private void doCall(Item item) throws XPathException {
        Sequence result;
        Sequence[] args = SequenceTool.makeSequenceArray(this.arguments.length);
        int i = 0;
        for (Expression exp : this.arguments) {
            if (Streamability.getSweep(exp) == Sweep.CONSUMING) {
                args[i++] = item == null ? EmptySequence.getInstance() : item;
                continue;
            }
            args[i++] = new LazySequence(exp.iterate(this.getContext()));
        }
        try {
            result = this.function.call(this.getContext(), args);
        }
        catch (XPathException e) {
            this.dynamicError(e);
            return;
        }
        CallableFeed.processItems(result.iterate(), this.getNextOutputter());
    }
}

