/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.jaxp;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.jaxp.TypedContentHandler;
import com.saxonica.ee.jaxp.ValidatorHandlerImpl;
import com.saxonica.ee.jaxp.ValidatorImpl;
import com.saxonica.ee.schema.PreparedSchema;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import javax.xml.validation.ValidatorHandler;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import org.xml.sax.helpers.XMLFilterImpl;

public class SchemaReference
extends Schema {
    private PreparedSchema schema;

    public SchemaReference(PreparedSchema schema) {
        this.schema = schema;
    }

    public PreparedSchema getPreparedSchema() {
        return this.schema;
    }

    @Override
    public Validator newValidator() {
        PipelineConfiguration pipe = this.schema.getConfiguration().makePipelineConfiguration();
        pipe.setHostLanguage(52);
        return new ValidatorImpl(pipe, this.schema);
    }

    @Override
    public ValidatorHandler newValidatorHandler() {
        EnterpriseConfiguration config = this.schema.getConfiguration();
        PipelineConfiguration pipe = config.makePipelineConfiguration();
        pipe.setHostLanguage(52);
        TypedContentHandler proxy = new TypedContentHandler();
        proxy.setPipelineConfiguration(pipe);
        proxy.setUnderlyingContentHandler(new XMLFilterImpl());
        ParseOptions options = new ParseOptions();
        options.setSchemaValidationMode(1);
        options.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
        options.setCheckEntityReferences(true);
        pipe.setParseOptions(options);
        Receiver realValidator = config.getDocumentValidator(proxy, this.schema.getSystemId(), options, null);
        ReceivingContentHandler rch = new ReceivingContentHandler();
        rch.setReceiver(realValidator);
        rch.setPipelineConfiguration(pipe);
        ValidatorHandlerImpl val = new ValidatorHandlerImpl();
        val.setPipelineConfiguration(pipe);
        val.setReceivingContentHandler(rch);
        val.setFinalProxy(proxy);
        return val;
    }
}

