/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.optim.IndexedValue;
import com.saxonica.ee.optim.SmallSearchableValue;
import java.util.Arrays;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public abstract class SearchableValue<T extends Item<?>>
implements GroundedValue<T> {
    protected T[] value = null;
    protected int end;

    public static <T extends Item<?>> SearchableValue<T> makeSearchableValue(SequenceIterator<? extends T> iter) throws XPathException {
        int end;
        Item[] array;
        if ((iter.getProperties() & 2) == 0) {
            T it;
            int used = 0;
            array = new Item[20];
            while ((it = iter.next()) != null) {
                if (used >= array.length - 1) {
                    array = Arrays.copyOf(array, used * 2);
                }
                array[used++] = it;
            }
            if (array.length - used > 100) {
                array = Arrays.copyOf(array, used);
            }
            end = used;
        } else {
            T it;
            end = ((LastPositionFinder)((Object)iter)).getLength();
            array = new Item[end];
            int i = 0;
            while ((it = iter.next()) != null) {
                array[i++] = it;
            }
        }
        if (end < 8) {
            return new SmallSearchableValue(array, end);
        }
        return new IndexedValue(array, end);
    }

    @Override
    public UnfailingIterator<T> iterate() {
        return new ArrayIterator(this.value, 0, this.end);
    }

    @Override
    public T itemAt(int n) {
        if (n < 0 || n >= this.end) {
            return null;
        }
        return this.value[n];
    }

    @Override
    public int getLength() {
        return this.end;
    }

    public abstract SequenceIterator<T> findItems(Expression var1, SequenceIterator<? extends AtomicValue> var2, boolean var3, boolean var4, AtomicComparer var5, XPathContext var6) throws XPathException;

    @Override
    public GroundedValue<T> subsequence(int start, int length) {
        if (length > this.end) {
            length = this.end;
        }
        return new SequenceExtent<T>(Arrays.asList(this.value).subList(start, start + length));
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return ExpressionTool.effectiveBooleanValue(this.iterate());
    }

    @Override
    public String getStringValue() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public CharSequence getStringValueCS() throws XPathException {
        return SequenceTool.getStringValue(this);
    }

    @Override
    public T head() {
        return this.value.length > 0 ? (T)this.value[0] : null;
    }

    @Override
    public GroundedValue<T> reduce() {
        int len = this.getLength();
        if (len == 0) {
            return EmptySequence.getInstance();
        }
        if (len == 1) {
            return this.itemAt(0);
        }
        return this;
    }
}

