/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ElementParticle;
import com.saxonica.ee.schema.ElementWildcard;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.fsa.AutomatonState;
import com.saxonica.ee.schema.fsa.Edge;
import com.saxonica.ee.schema.fsa.FiniteStateMachine;
import com.saxonica.ee.schema.fsa.State;
import com.saxonica.ee.schema.fsa.SuffixState;
import com.saxonica.ee.validate.AnyTypeValidator;
import com.saxonica.ee.validate.AttributeValidator;
import com.saxonica.ee.validate.ContentValidator;
import com.saxonica.ee.validate.LaxValidator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Whitespace;

public class ComplexContentValidator
extends AttributeValidator {
    UserComplexType type;
    boolean mixed;
    String fixedValue = null;
    String defaultValue = null;
    State state;
    int previousElement = -1;
    boolean ignoreIgnorable;
    FastStringBuffer buffer;
    boolean foundChildren = false;

    public ComplexContentValidator(ElementDecl declaration, UserComplexType type, Receiver next) throws MissingComponentException {
        super(next);
        this.setSchemaType(type);
        if (declaration != null) {
            this.defaultValue = declaration.getDefaultValueLexicalForm();
            AtomicSequence fixed = declaration.getFixedValue();
            if (fixed != null) {
                this.fixedValue = fixed.getStringValue();
            }
        }
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        super.setPipelineConfiguration(pipe);
        this.ignoreIgnorable = this.getConfiguration().getParseOptions().getSpaceStrippingRule() != NoElementsSpaceStrippingRule.getInstance();
    }

    public void setSchemaType(UserComplexType type) throws MissingComponentException {
        this.type = type;
        this.mixed = type.isMixedContent();
        this.state = type.getInitialState();
        this.setAnnotation(type);
        this.setAttributeGroup(type.getCombinedAttributeGroup());
    }

    @Override
    public SchemaType getSchemaType() {
        return this.type;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        SchemaType annotation;
        if (this.locallyInvalid) {
            this.recover(elemName, location, properties);
            return;
        }
        if (this.fixedValue != null) {
            String message = "Element " + Err.wrap(elemName.getDisplayName(), 1) + " cannot appear here, because the containing " + this.getContainingElementName() + " element has fixed content";
            ValidationFailure ve = new ValidationFailure(message);
            ve.setConstraintReference(1, "cvc-elt", "5.2.2.1");
            ve.setSchemaType(this.type);
            this.reportValidationError(ve, true, location);
            this.locallyInvalid = true;
            this.recover(elemName, location, properties);
            return;
        }
        this.foundChildren = true;
        int fingerprint = elemName.obtainFingerprint(this.getNamePool());
        Edge edge = this.state.getTransition(fingerprint, this.type);
        if (edge == null) {
            FiniteStateMachine machine = this.type.getFiniteStateMachine();
            Wildcard openContentWildcard = machine.getOpenContentWildcard();
            if (openContentWildcard != null && openContentWildcard.matches(elemName, true, this.getConfiguration(), this.type)) {
                if (machine.isOpenContentInterleaved()) {
                    this.childValidator = new LaxValidator(this.getNextReceiver());
                    SchemaType annotation2 = this.processWildcardTerm(openContentWildcard, elemName, location);
                    super.startElement(elemName, annotation2, location, properties);
                    return;
                }
                if (this.state.isFinalState()) {
                    this.state = SuffixState.getInstance();
                    this.childValidator = new LaxValidator(this.getNextReceiver());
                    SchemaType annotation3 = this.processWildcardTerm(openContentWildcard, elemName, location);
                    super.startElement(elemName, annotation3, location, properties);
                    return;
                }
            }
            String message = this.supplyReasonForNonMatch(elemName);
            ValidationFailure ve = new ValidationFailure(message);
            ve.setConstraintReference(1, "cvc-complex-type", "2.4");
            ve.setSchemaType(this.type);
            this.reportValidationError(ve, true, location);
            this.locallyInvalid = true;
            this.recover(elemName, location, properties);
            return;
        }
        try {
            this.previousElement = fingerprint;
            this.state = edge.makeTransition(this.state);
        }
        catch (ValidationException e) {
            String message = e.getMessage();
            if (this.getContainingElement() != null) {
                message = "In content of " + this.getContainingElementName() + ": " + message;
            }
            ValidationFailure ve = e.getValidationFailure();
            ve.setSchemaType(this.type);
            this.reportValidationError(ve, true, location);
            this.locallyInvalid = true;
            this.recover(elemName, location, properties);
            return;
        }
        Term term = edge.getTerm();
        if (term instanceof ElementDecl) {
            ElementDecl decl = (ElementDecl)term;
            this.makeChildValidator(decl, elemName.getStructuredQName(), location, 0);
            this.childValidator.setContainingElement(decl.getComponentName(), location);
            annotation = this.childValidator.getAnnotation();
        } else {
            Wildcard card = (Wildcard)term;
            annotation = this.processWildcardTerm(card, elemName, location);
            if (this.childValidator == null) {
                this.childValidator = new LaxValidator(this.getNextReceiver());
            }
        }
        super.startElement(elemName, annotation, location, properties);
    }

    private String supplyReasonForNonMatch(NodeName nodeName) {
        int fingerprint = nodeName == null ? -1 : nodeName.obtainFingerprint(this.getNamePool());
        FastStringBuffer fsb = new FastStringBuffer(64);
        if (this.getContainingElement() != null) {
            fsb.append("In content of " + this.getContainingElementName() + ": ");
        }
        boolean explained = false;
        if (nodeName == null) {
            if (this.previousElement == -1) {
                fsb.append("Empty content is not allowed. ");
            } else {
                fsb.append("The content is incomplete. ");
            }
        } else if (this.state instanceof SuffixState) {
            fsb.append("The content model does not allow element " + Err.wrap(nodeName.getStructuredQName().getEQName(), 1) + " to appear after an element that matches the suffix open content wildcard. ");
            explained = true;
        } else {
            String s;
            Wildcard openContentWildcard;
            fsb.append("The content model does not allow element ");
            fsb.append(Err.wrap(nodeName.getStructuredQName().getEQName(), 1));
            if (this.previousElement == -1) {
                fsb.append(" to appear as the first child. ");
            } else if (this.previousElement == fingerprint) {
                try {
                    if (Cardinality.allowsMany(this.type.getElementParticleCardinality(fingerprint, false))) {
                        fsb.append(" to appear this many times. ");
                    } else {
                        fsb.append(" to appear more than once. ");
                    }
                }
                catch (MissingComponentException e) {
                    fsb.append(" to appear more than once. ");
                }
                explained = true;
            } else {
                fsb.append(" to appear immediately after element ");
                fsb.append(Err.wrap(this.getNamePool().getClarkName(this.previousElement), 1));
                fsb.append(". ");
            }
            try {
                if (!explained && this.type.getElementParticleType(fingerprint, false) != null) {
                    StructuredQName omission = null;
                    HashSet<StructuredQName> possibleOmissions = new HashSet<StructuredQName>();
                    StructuredQName firstOmission = null;
                    Iterator<Edge> edges = this.state.getEdges();
                    while (edges.hasNext()) {
                        Edge e = edges.next();
                        if (!(e.getParticle() instanceof ElementParticle)) continue;
                        omission = e.getParticle().getTargetComponentName();
                        int omittedfp = ((ElementParticle)e.getParticle()).getDeclaration().getFingerprint();
                        AutomatonState s2 = this.state.getTransition(omittedfp, this.type).getTargetState();
                        if (s2.getTransition(fingerprint, this.type) == null) continue;
                        possibleOmissions.add(omission);
                        if (firstOmission != null) continue;
                        firstOmission = omission;
                    }
                    if (!possibleOmissions.isEmpty()) {
                        if (possibleOmissions.size() == 1) {
                            fsb.append("It must be preceded by " + Err.wrap(firstOmission.getEQName(), 1) + ". ");
                        } else if (possibleOmissions.size() > 5) {
                            fsb.append("It must be preceded by another element, for example " + Err.wrap(firstOmission.getEQName(), 1) + ". ");
                        } else {
                            fsb.append("It must be preceded by one of: ");
                            boolean first = true;
                            for (StructuredQName poss : possibleOmissions) {
                                if (!first) {
                                    fsb.append(", ");
                                }
                                if (poss.getURI().equals(nodeName.getURI())) {
                                    fsb.append(Err.wrap(poss.getLocalPart(), 1));
                                } else {
                                    fsb.append(Err.wrap(poss.getEQName(), 1));
                                }
                                first = false;
                            }
                            fsb.append(". ");
                        }
                        explained = true;
                    }
                }
            }
            catch (MissingComponentException omission) {
                // empty catch block
            }
            if (!explained) {
                Iterator<Edge> edges = this.state.getEdges();
                while (edges.hasNext()) {
                    String local;
                    String foundLocal = nodeName.getLocalPart();
                    String foundURI = nodeName.getURI();
                    Edge e = edges.next();
                    if (!(e.getParticle() instanceof ElementParticle) || !(local = ((ElementParticle)e.getParticle()).getName()).equals(foundLocal)) continue;
                    String uri = ((ElementParticle)e.getParticle()).getNamespaceURI();
                    fsb.append("The element is in " + ("".equals(foundURI) ? "no namespace" : "namespace " + foundURI) + " but it should be in " + ("".equals(uri) ? "no namespace" : "namespace " + uri) + ". ");
                    explained = true;
                    break;
                }
            }
            if (!explained && (openContentWildcard = this.type.getOpenContentWildcard()) != null && (s = openContentWildcard.reasonForNonMatch(nodeName, true, this.getConfiguration(), this.type)) != null) {
                fsb.append("It does not match the open content wildcard: ");
                fsb.append(s);
            }
        }
        if (!explained) {
            HashSet<String> specificTransitions = new HashSet<String>();
            StructuredQName expected = null;
            HashSet<String> specificURIs = new HashSet<String>();
            String namespace = null;
            Iterator<Edge> ii = this.state.getEdges();
            while (ii.hasNext()) {
                Edge e = ii.next();
                if (!(e.getParticle() instanceof ElementParticle)) continue;
                expected = e.getParticle().getTargetComponentName();
                specificTransitions.add(((ElementParticle)e.getParticle()).getDisplayName());
                namespace = ((ElementParticle)e.getParticle()).getNamespaceURI();
                specificURIs.add(namespace);
            }
            HashSet<Wildcard> wildcards = new HashSet<Wildcard>();
            Iterator<Edge> ii2 = this.state.getEdges();
            while (ii2.hasNext()) {
                Edge e = ii2.next();
                if (!(e.getParticle() instanceof ElementWildcard)) continue;
                wildcards.add(((ElementWildcard)e.getParticle()).getWildcard());
            }
            if (specificTransitions.isEmpty() && wildcards.isEmpty()) {
                if (this.previousElement == -1) {
                    fsb.append("In fact, nothing is allowed: the type has no valid instances. ");
                } else {
                    fsb.append("No further elements are allowed at this point. ");
                }
            } else {
                if (!specificTransitions.isEmpty()) {
                    if (specificTransitions.size() == 1) {
                        fsb.append("Expected ");
                        fsb.append(Err.wrap(expected.getEQName(), 1));
                        if (this.state.isFinalState()) {
                            fsb.append(" or nothing");
                        }
                        fsb.append(". ");
                    } else {
                        boolean uniform = specificURIs.size() == 1;
                        fsb.append("The following elements would be valid here");
                        if (uniform) {
                            fsb.append(", all in ");
                            fsb.append("".equals(namespace) ? "no namespace" : "namespace " + namespace);
                        }
                        fsb.append(": ");
                        int i = 0;
                        for (String s : specificTransitions) {
                            if (i >= 10) {
                                fsb.append(", and " + (specificTransitions.size() - 10) + " others");
                                break;
                            }
                            if (i++ > 0) {
                                fsb.append(", ");
                            }
                            if (uniform) {
                                int c = s.indexOf(58);
                                if (c < 0) {
                                    fsb.append(s);
                                    continue;
                                }
                                fsb.append(s.substring(c + 1));
                                continue;
                            }
                            fsb.append(s);
                        }
                        if (this.state.isFinalState()) {
                            fsb.append(" (or nothing)");
                        }
                        fsb.append(". ");
                    }
                }
                if (nodeName == null) {
                    if (!wildcards.isEmpty()) {
                        if (!specificTransitions.isEmpty()) {
                            fsb.append("Alternatively, an element that matches ");
                        } else {
                            fsb.append("Expected an element that matches ");
                        }
                        if (wildcards.size() == 1) {
                            fsb.append("the");
                        } else {
                            fsb.append("an");
                        }
                        fsb.append(" <xs:any> wildcard. ");
                    }
                } else if (wildcards.size() == 1) {
                    for (Wildcard w : wildcards) {
                        fsb.append("There is an <xs:any> wildcard, but it does not match: ");
                        fsb.append(w.reasonForNonMatch(nodeName, true, this.getConfiguration(), this.type));
                    }
                } else if (wildcards.size() > 1) {
                    fsb.append("There are several <xs:any> wildcards, but none of them match. ");
                }
            }
        }
        return fsb.toString();
    }

    private void recover(NodeName elemName, Location locationId, int properties) throws XPathException {
        this.childValidator = null;
        SchemaType childType = this.type.getContextDeterminedTypeForElement(elemName.getStructuredQName());
        if (!(childType == null || childType.isComplexType() && ((ComplexType)childType).isAbstract())) {
            ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>(1);
            this.childValidator = ComplexContentValidator.makeValidator(null, elemName.getStructuredQName(), locationId, this.getValidationContext(), childType, 8, this.getPipelineConfiguration(), this.nextReceiver, failures);
            for (ValidationFailure failure : failures) {
                this.reportValidationError(failure, false, locationId);
            }
        }
        if (this.childValidator == null) {
            childType = AnyType.getInstance();
            this.childValidator = new AnyTypeValidator(this.nextReceiver);
        }
        this.nextReceiver.startElement(elemName, childType, locationId, properties);
    }

    @Override
    protected ContentValidator getChildValidator() {
        return this.childValidator;
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        this.checkNoCharactersWhenNil(locationId);
        if (this.mixed) {
            if (this.fixedValue != null || this.defaultValue != null) {
                if (this.buffer == null) {
                    this.buffer = new FastStringBuffer(chars.length());
                }
                this.buffer.append(chars);
            }
            this.nextReceiver.characters(chars, locationId, properties);
        } else if (Whitespace.isWhite(chars)) {
            if (!this.ignoreIgnorable) {
                this.nextReceiver.characters(chars, locationId, properties);
            }
        } else {
            String message = "The content model for " + this.getContainingElementName() + " does not allow character content";
            ValidationFailure ve = new ValidationFailure(message);
            ve.setSchemaType(this.type);
            ve.setConstraintReference(1, "cvc-complex-type", "2.3");
            this.reportValidationError(ve, true, locationId);
        }
    }

    @Override
    public void endElement() throws XPathException {
        ValidationFailure ve;
        String message;
        if (this.fixedValue != null) {
            if (this.isNil()) {
                String message2 = "The " + this.getContainingElementName() + " has a fixed value so it must not be nil";
                ValidationFailure ve2 = new ValidationFailure(message2);
                ve2.setConstraintReference(1, "cvc-elt", "3.2.2");
                ve2.setSchemaType(this.type);
                this.reportValidationError(ve2, true, this.getContainingElementLocationId());
                this.nextReceiver.endElement();
                return;
            }
            if (this.buffer == null || this.buffer.isEmpty()) {
                this.characters(this.fixedValue, ExplicitLocation.UNKNOWN_LOCATION, 0);
            } else if (!this.buffer.toString().equals(this.fixedValue)) {
                message = "The content of " + this.getContainingElementName() + " differs from the fixed value defined in the schema. Fixed value is " + Err.wrap(this.fixedValue, 4) + ", actual value is " + Err.wrap(this.buffer, 4);
                ve = new ValidationFailure(message);
                ve.setSchemaType(this.type);
                ve.setConstraintReference(1, "cvc-elt", "5.2.2.2");
                this.reportValidationError(ve, true, this.getContainingElementLocationId());
            }
        }
        if (this.defaultValue != null && !this.foundChildren && (this.buffer == null || this.buffer.isEmpty())) {
            this.characters(this.defaultValue, ExplicitLocation.UNKNOWN_LOCATION, 0);
        }
        if (!(this.state.isFinalState() || this.isNil() || this.locallyInvalid)) {
            message = this.supplyReasonForNonMatch(null);
            ve = new ValidationFailure(message);
            ve.setSchemaType(this.type);
            ve.setConstraintReference(1, "cvc-complex-type", "2.4");
            this.reportValidationError(ve, true, this.getContainingElementLocationId());
        }
        this.nextReceiver.endElement();
    }
}

