/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTagFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POSTagFormatMapper {
    private static final Logger logger = LoggerFactory.getLogger(POSTagFormatMapper.class);
    private static final Map<String, String> CONVERSION_TABLE_PENN_TO_UD = new HashMap<String, String>();
    private static final Map<String, String> CONVERSION_TABLE_UD_TO_PENN = new HashMap<String, String>();
    private final POSTagFormat modelFormat;

    protected POSTagFormatMapper(String[] possibleOutcomes) {
        this.modelFormat = this.guessModelTagFormat(possibleOutcomes);
    }

    public String[] convertTags(List<String> tags) {
        Objects.requireNonNull(tags, "Supplied tags must not be NULL.");
        return (String[])tags.stream().map(this::convertTag).toArray(String[]::new);
    }

    public String convertTag(String tag) {
        switch (this.modelFormat) {
            case UD: {
                return CONVERSION_TABLE_UD_TO_PENN.getOrDefault(tag, "?");
            }
            case PENN: {
                if ("NOUN".equals(tag)) {
                    logger.warn("Ambiguity detected: NN can be 'NN' or 'NNS' depending on the number. Returning 'NN'.");
                }
                if ("PART".equals(tag)) {
                    logger.warn("Ambiguity detected: PART can be 'RP' or 'TO'. Returning 'RP'.");
                }
                if ("PROPN".equals(tag)) {
                    logger.warn("Ambiguity detected: Can be 'NNP' or 'NNPS. Returning 'NNP'");
                }
                if ("PUNCT".equals(tag)) {
                    logger.warn("Ambiguity detected: PUNCT needs specific punctuation mapping. Returning '.'");
                }
                if ("VERB".equals(tag)) {
                    logger.warn("Ambiguity detected: VERB can be 'VB', 'VBD', 'VBG', 'VBN', 'VBP', 'VBZ'. Returning 'VERB'.");
                }
                return CONVERSION_TABLE_PENN_TO_UD.getOrDefault(tag, "?");
            }
        }
        return tag;
    }

    public POSTagFormat getGuessedFormat() {
        return this.modelFormat;
    }

    private POSTagFormat guessModelTagFormat(String[] outcomes) {
        Objects.requireNonNull(outcomes, "Outcomes must not be NULL.");
        int udMatches = 0;
        int pennMatches = 0;
        for (String outcome : outcomes) {
            if (CONVERSION_TABLE_UD_TO_PENN.containsKey(outcome)) {
                ++udMatches;
            }
            if (!CONVERSION_TABLE_PENN_TO_UD.containsKey(outcome)) continue;
            ++pennMatches;
        }
        if (udMatches > pennMatches) {
            return POSTagFormat.UD;
        }
        if (pennMatches > udMatches) {
            return POSTagFormat.PENN;
        }
        logger.warn("Detected an unknown POS format.");
        return POSTagFormat.UNKNOWN;
    }

    public static POSTagFormat guessFormat(POSModel posModel) {
        Objects.requireNonNull(posModel, "POSModel must not be NULL.");
        Objects.requireNonNull(posModel.getPosSequenceModel(), "POSSequenceModel must not be NULL.");
        POSTagFormatMapper mapper = new POSTagFormatMapper(posModel.getPosSequenceModel().getOutcomes());
        return mapper.getGuessedFormat();
    }

    static {
        CONVERSION_TABLE_PENN_TO_UD.put("#", "SYM");
        CONVERSION_TABLE_PENN_TO_UD.put("$", "SYM");
        CONVERSION_TABLE_PENN_TO_UD.put("''", "PUNCT");
        CONVERSION_TABLE_PENN_TO_UD.put(",", "PUNCT");
        CONVERSION_TABLE_PENN_TO_UD.put("-LRB-", "PUNCT");
        CONVERSION_TABLE_PENN_TO_UD.put("-RRB-", "PUNCT");
        CONVERSION_TABLE_PENN_TO_UD.put(".", "PUNCT");
        CONVERSION_TABLE_PENN_TO_UD.put(":", "PUNCT");
        CONVERSION_TABLE_PENN_TO_UD.put("AFX", "ADJ");
        CONVERSION_TABLE_PENN_TO_UD.put("CC", "CCONJ");
        CONVERSION_TABLE_PENN_TO_UD.put("CD", "NUM");
        CONVERSION_TABLE_PENN_TO_UD.put("DT", "DET");
        CONVERSION_TABLE_PENN_TO_UD.put("EX", "PRON");
        CONVERSION_TABLE_PENN_TO_UD.put("FW", "X");
        CONVERSION_TABLE_PENN_TO_UD.put("HYPH", "PUNCT");
        CONVERSION_TABLE_PENN_TO_UD.put("IN", "ADP");
        CONVERSION_TABLE_PENN_TO_UD.put("JJ", "ADJ");
        CONVERSION_TABLE_PENN_TO_UD.put("JJR", "ADJ");
        CONVERSION_TABLE_PENN_TO_UD.put("JJS", "ADJ");
        CONVERSION_TABLE_PENN_TO_UD.put("LS", "X");
        CONVERSION_TABLE_PENN_TO_UD.put("MD", "VERB");
        CONVERSION_TABLE_PENN_TO_UD.put("NIL", "X");
        CONVERSION_TABLE_PENN_TO_UD.put("NN", "NOUN");
        CONVERSION_TABLE_PENN_TO_UD.put("NNP", "PROPN");
        CONVERSION_TABLE_PENN_TO_UD.put("NNPS", "PROPN");
        CONVERSION_TABLE_PENN_TO_UD.put("NNS", "NOUN");
        CONVERSION_TABLE_PENN_TO_UD.put("PDT", "DET");
        CONVERSION_TABLE_PENN_TO_UD.put("POS", "PART");
        CONVERSION_TABLE_PENN_TO_UD.put("PRP", "PRON");
        CONVERSION_TABLE_PENN_TO_UD.put("PRP$", "DET");
        CONVERSION_TABLE_PENN_TO_UD.put("RB", "ADV");
        CONVERSION_TABLE_PENN_TO_UD.put("RBR", "ADV");
        CONVERSION_TABLE_PENN_TO_UD.put("RBS", "ADV");
        CONVERSION_TABLE_PENN_TO_UD.put("RP", "ADP");
        CONVERSION_TABLE_PENN_TO_UD.put("SYM", "SYM");
        CONVERSION_TABLE_PENN_TO_UD.put("TO", "PART");
        CONVERSION_TABLE_PENN_TO_UD.put("UH", "INTJ");
        CONVERSION_TABLE_PENN_TO_UD.put("VB", "VERB");
        CONVERSION_TABLE_PENN_TO_UD.put("VBD", "VERB");
        CONVERSION_TABLE_PENN_TO_UD.put("VBG", "VERB");
        CONVERSION_TABLE_PENN_TO_UD.put("VBN", "VERB");
        CONVERSION_TABLE_PENN_TO_UD.put("VBP", "VERB");
        CONVERSION_TABLE_PENN_TO_UD.put("VBZ", "VERB");
        CONVERSION_TABLE_PENN_TO_UD.put("WDT", "DET");
        CONVERSION_TABLE_PENN_TO_UD.put("WP", "PRON");
        CONVERSION_TABLE_PENN_TO_UD.put("WP$", "DET");
        CONVERSION_TABLE_PENN_TO_UD.put("WRB", "ADV");
        CONVERSION_TABLE_UD_TO_PENN.put("ADJ", "JJ");
        CONVERSION_TABLE_UD_TO_PENN.put("ADP", "IN");
        CONVERSION_TABLE_UD_TO_PENN.put("ADV", "RB");
        CONVERSION_TABLE_UD_TO_PENN.put("AUX", "MD");
        CONVERSION_TABLE_UD_TO_PENN.put("CCONJ", "CC");
        CONVERSION_TABLE_UD_TO_PENN.put("DET", "DT");
        CONVERSION_TABLE_UD_TO_PENN.put("INTJ", "UH");
        CONVERSION_TABLE_UD_TO_PENN.put("NOUN", "NN");
        CONVERSION_TABLE_UD_TO_PENN.put("NUM", "CD");
        CONVERSION_TABLE_UD_TO_PENN.put("PART", "RP");
        CONVERSION_TABLE_UD_TO_PENN.put("PRON", "PRP");
        CONVERSION_TABLE_UD_TO_PENN.put("PROPN", "NNP");
        CONVERSION_TABLE_UD_TO_PENN.put("PUNCT", ".");
        CONVERSION_TABLE_UD_TO_PENN.put("SCONJ", "IN");
        CONVERSION_TABLE_UD_TO_PENN.put("SYM", "SYM");
        CONVERSION_TABLE_UD_TO_PENN.put("VERB", "VB");
        CONVERSION_TABLE_UD_TO_PENN.put("X", "FW");
    }

    public static class NoOp
    extends POSTagFormatMapper {
        protected NoOp() {
            super(new String[0]);
        }

        @Override
        public String[] convertTags(List<String> tags) {
            Objects.requireNonNull(tags, "tags must not be NULL.");
            return tags.toArray(new String[0]);
        }

        @Override
        public String convertTag(String tag) {
            return tag;
        }

        @Override
        public POSTagFormat getGuessedFormat() {
            return POSTagFormat.CUSTOM;
        }
    }
}

