/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SchemaNodeFactory;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.Version;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.om.Durability;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.type.SchemaException;

public class SchemaDocumentTransformer {
    private PreparedStylesheet pss;

    public SchemaDocumentTransformer(Configuration config, String filename) throws SchemaException {
        this.compileStylesheet(config, filename);
    }

    private void compileStylesheet(Configuration config, String filename) throws SchemaException {
        try {
            InputStream in = Version.platform.locateResource(filename, new ArrayList<String>());
            StreamSource ss = new StreamSource(in, filename);
            CompilerInfo info = config.getDefaultXsltCompilerInfo();
            this.pss = Compilation.compileSingletonPackage(config, info, ss);
        }
        catch (XPathException e) {
            throw new SchemaException(e);
        }
    }

    public TreeInfo transform(SchemaCompiler compiler, PipelineConfiguration pipe, SchemaElement referrer, NodeInfo input, GlobalParameterSet params) throws SchemaException {
        try {
            XsltController transformer = this.pss.newController();
            transformer.initializeController(params);
            LinkedTreeBuilder builder = new LinkedTreeBuilder(pipe, Durability.LASTING);
            builder.setNodeFactory(new SchemaNodeFactory(compiler, pipe, referrer));
            transformer.setBaseOutputURI(input.getSystemId());
            transformer.setGlobalContextItem(input);
            transformer.applyTemplates(input, new TreeReceiver(builder));
            return builder.getCurrentRoot().getTreeInfo();
        }
        catch (TransformerException e) {
            throw new SchemaException(e);
        }
    }
}

