/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.morph;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import marmot.core.Sequence;
import marmot.morph.MorphModel;
import marmot.morph.MorphOptions;
import marmot.morph.Word;
import marmot.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class MorphModelTest {
    public void testFormExtraction(String inform, String expected_form, Collection<Character> expected_chars, MorphOptions options) {
        MorphModel model = new MorphModel();
        model.init(options, new LinkedList<Sequence>());
        Word word = new Word(inform);
        model.addIndexes(word, true);
        System.err.println(model.getWordTable());
        System.err.println(model.getCharTable());
        Assert.assertEquals((long)0L, (long)model.getWordTable().toIndex(expected_form));
        Assert.assertEquals((long)1L, (long)model.getWordTable().size());
        HashSet<Character> expected_char_set = new HashSet<Character>(expected_chars);
        Assert.assertEquals(expected_char_set, model.getCharTable().keySet());
    }

    @Test
    public void testFormExtraction() {
        MorphOptions options = new MorphOptions();
        this.testFormExtraction("Abc", "Abc", Arrays.asList(Character.valueOf('A'), Character.valueOf('b'), Character.valueOf('c')), options);
        options = new MorphOptions();
        options.setProperty("form-normalization", StringUtils.Mode.lower.toString());
        this.testFormExtraction("Abc", "abc", Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')), options);
        this.testFormExtraction("-LRB-", "(", Arrays.asList(Character.valueOf('(')), options);
        options = new MorphOptions();
        options.setProperty("form-normalization", StringUtils.Mode.umlaut.toString());
        this.testFormExtraction("\u00d6l", "oel", Arrays.asList(Character.valueOf('o'), Character.valueOf('e'), Character.valueOf('l')), options);
    }

    public void testShapeExtraction(String inform, int expected, MorphOptions options) {
        MorphModel model = new MorphModel();
        model.init(options, new LinkedList<Sequence>());
        Word word = new Word(inform);
        model.addIndexes(word, true);
        Assert.assertEquals((long)expected, (long)word.getWordSignature());
    }

    @Test
    public void testShapeExtraction() {
        MorphOptions options = new MorphOptions();
        options.setProperty("special-signature", "false");
        this.testShapeExtraction("?", 0, options);
        this.testShapeExtraction("abc", 1, options);
        this.testShapeExtraction("DEF", 2, options);
        this.testShapeExtraction("-", 4, options);
        this.testShapeExtraction("1234", 8, options);
        this.testShapeExtraction("1234abc", 9, options);
        this.testShapeExtraction("1234-abc", 13, options);
        this.testShapeExtraction("1234-DEF", 14, options);
        this.testShapeExtraction("1234-DEF-abc", 15, options);
        options = new MorphOptions();
        options.setProperty("special-signature", "true");
        this.testShapeExtraction("abc", 1, options);
        this.testShapeExtraction("DEF", 2, options);
        this.testShapeExtraction("-", 20, options);
        this.testShapeExtraction("1234", 8, options);
        this.testShapeExtraction("?", 16, options);
        this.testShapeExtraction("1234abc", 9, options);
        this.testShapeExtraction("1234#abc", 25, options);
        this.testShapeExtraction("1234-abc", 29, options);
        this.testShapeExtraction("1234-DEF", 30, options);
        this.testShapeExtraction("1234-DEF-abc", 31, options);
        options = new MorphOptions();
        options.setProperty("special-signature", "true");
        options.setProperty("form-normalization", StringUtils.Mode.lower.toString());
        this.testShapeExtraction("abc", 1, options);
        this.testShapeExtraction("DEF", 2, options);
        this.testShapeExtraction("-", 20, options);
        this.testShapeExtraction("1234", 8, options);
        this.testShapeExtraction("?", 16, options);
        this.testShapeExtraction("1234abc", 9, options);
        this.testShapeExtraction("1234#abc", 25, options);
        this.testShapeExtraction("1234-abc", 29, options);
        this.testShapeExtraction("1234-DEF", 30, options);
        this.testShapeExtraction("1234-DEF-abc", 31, options);
    }
}

