/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.GroupBoundaryTester;
import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CompositeAtomicKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class GroupAdjacentTester
extends GroupBoundaryTester {
    private CompositeAtomicKey currentGroupingComparisonKey;
    private final StringCollator collator;
    private AtomicSequence currentGroupingKey;
    private final int implicitTimezone;

    public GroupAdjacentTester(ForEachGroup expression, XPathContext context) {
        super(expression, context);
        this.collator = expression.getCollation();
        this.implicitTimezone = context.getImplicitTimezone();
    }

    @Override
    public boolean notifyItem() throws XPathException {
        Expression groupingKey = this.getControllingExpression().getGroupingKey();
        ArrayList<AtomicMatchKey> comparisonKeyList = new ArrayList<AtomicMatchKey>();
        SequenceIterator iter = groupingKey.iterate(this.getLocalContext());
        AtomicArray key = new AtomicArray(iter);
        for (AtomicValue val : key) {
            comparisonKeyList.add(val.getXPathMatchKey(this.collator, this.implicitTimezone));
        }
        CompositeAtomicKey cak = new CompositeAtomicKey(comparisonKeyList);
        boolean isNewGroup = this.currentGroupingComparisonKey == null || !this.currentGroupingComparisonKey.equals(cak);
        this.currentGroupingComparisonKey = cak;
        if (isNewGroup) {
            this.currentGroupingKey = key;
        }
        return isNewGroup;
    }

    public AtomicSequence getCurrentGroupingKey() {
        return this.currentGroupingKey;
    }
}

