/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.Serializable;
import java.util.Arrays;
import marmot.core.Feature;

public class Encoder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] bytes_;
    private short current_array_length_;
    private short current_bit_index_;
    private State state_;

    public Encoder(int capacity) {
        this.bytes_ = new int[capacity];
        this.state_ = new State();
        this.reset();
    }

    public static int bitsNeeded(int max_value) {
        int num_bits = 1;
        while ((max_value /= 2) != 0) {
            ++num_bits;
        }
        return num_bits;
    }

    public void append(boolean value) {
        this.append(value ? 0 : 1, 1);
    }

    public void append(int value, int bits_needed) {
        assert (value >= 0);
        assert (Encoder.bitsNeeded(value) <= bits_needed) : value;
        while (bits_needed != 0) {
            if (this.current_bit_index_ == 32) {
                this.current_array_length_ = (short)(this.current_array_length_ + 1);
                this.current_bit_index_ = 0;
            }
            int bits_left = 32 - this.current_bit_index_;
            int bits = Math.min(bits_left, bits_needed);
            int mask = (2 << bits - 1) - 1;
            int b = value & mask;
            value >>= bits;
            bits_needed -= bits;
            int n = this.current_array_length_ - 1;
            this.bytes_[n] = this.bytes_[n] + (b << this.current_bit_index_);
            this.current_bit_index_ = (short)(this.current_bit_index_ + bits);
        }
        assert (value == 0);
    }

    public Feature getFeature() {
        Feature feature = new Feature(this.bytes_.length);
        this.copyToFeature(feature);
        return feature;
    }

    public void reset() {
        this.current_array_length_ = 0;
        this.current_bit_index_ = (short)32;
        this.storeState();
        Arrays.fill(this.bytes_, 0);
    }

    public Feature getFeature(boolean flag) {
        return this.getFeature();
    }

    public void storeState() {
        this.storeState(this.state_);
    }

    public void storeState(State state) {
        state.array_length_ = this.current_array_length_;
        state.bit_index_ = this.current_bit_index_;
        state.byte_ = this.current_array_length_ > 0 ? this.bytes_[this.current_array_length_ - 1] : 0;
    }

    public void restoreState() {
        this.restoreState(this.state_);
    }

    public void restoreState(State state) {
        Arrays.fill(this.bytes_, (int)state.array_length_, (int)this.current_array_length_, 0);
        this.current_array_length_ = state.array_length_;
        this.current_bit_index_ = state.bit_index_;
        if (this.current_array_length_ > 0) {
            this.bytes_[this.current_array_length_ - 1] = state.byte_;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.bytes_);
        result = 31 * result + this.current_array_length_;
        result = 31 * result + this.current_bit_index_;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Encoder other = (Encoder)obj;
        if (!Arrays.equals(this.bytes_, other.bytes_)) {
            return false;
        }
        if (this.current_array_length_ != other.current_array_length_) {
            return false;
        }
        return this.current_bit_index_ == other.current_bit_index_;
    }

    public String toString() {
        return "Encoder [bytes_=" + Arrays.toString(this.bytes_) + ", current_array_length_=" + this.current_array_length_ + ", current_bit_index_=" + this.current_bit_index_ + ", stored_array_length_=" + this.state_.array_length_ + ", stored_bit_index_=" + this.state_.bit_index_ + ", stored_byte_=" + this.state_.byte_ + "]";
    }

    public int getCapacity() {
        return this.bytes_.length;
    }

    public void copyToFeature(Feature feature) {
        System.arraycopy(this.bytes_, 0, feature.getBytes(), 0, this.bytes_.length);
        feature.setArrayLength(this.current_array_length_);
        feature.setBitIndex(this.current_bit_index_);
    }

    public int getCurrentLength() {
        return this.current_array_length_;
    }

    public static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private short array_length_;
        private short bit_index_;
        private int byte_;
    }
}

