/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.mapper.latin;

import java.io.IOException;
import java.io.Writer;
import marmot.morph.mapper.Node;
import marmot.morph.mapper.SyntaxTree;
import marmot.morph.mapper.SyntaxTreeIterator;
import marmot.morph.mapper.latin.LatMorNormalizer;
import marmot.morph.mapper.latin.LdtTagReader;
import marmot.util.FileUtils;

public class LdtConverter {
    public static void main(String[] args2) throws IOException {
        LdtConverter conv = new LdtConverter();
        conv.convert(args2[0], args2[1]);
    }

    public void convert(String input_file, String output_file) throws IOException {
        SyntaxTreeIterator iterator2 = new SyntaxTreeIterator(input_file, 1, 2, 3, 5, 6, 7, false);
        Writer writer = FileUtils.openFileWriter(output_file);
        LdtTagReader reader = new LdtTagReader();
        while (iterator2.hasNext()) {
            SyntaxTree tree = iterator2.next();
            for (Node node : tree.getNodes()) {
                node.setForm(LatMorNormalizer.normalize(node.getForm()));
                node.setLemma(LatMorNormalizer.normalize(node.getLemma()));
                node.setMorphTag(reader.read(node.getPos(), node.getFeats()));
            }
            tree.write(writer);
            writer.write(10);
        }
        writer.close();
    }
}

