/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.config;

import com.saxonica.config.EnterpriseConfiguration;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.DirectResourceResolver;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.trans.XPathException;

public class StandardSchemaResolver
implements SchemaURIResolver {
    private EnterpriseConfiguration config;
    private static final StreamSource[] EMPTY_SOURCE_ARRAY = new StreamSource[0];
    private ResourceResolver resourceResolver;

    public StandardSchemaResolver(EnterpriseConfiguration config) {
        this.setConfiguration(config);
    }

    @Override
    public void setConfiguration(Configuration config) {
        this.config = (EnterpriseConfiguration)config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setResourceResolver(ResourceResolver resolver) {
        this.resourceResolver = resolver;
    }

    @Override
    public Source[] resolve(String targetNamespace, String baseURI, String[] locations) throws XPathException {
        Source source;
        if (this.config == null) {
            throw new NullPointerException("No configuration supplied to schema URI resolver");
        }
        if (targetNamespace != null && this.config.isSchemaAvailable(NamespaceUri.of(targetNamespace)) && !this.config.getConfigurationProperty(Feature.MULTIPLE_SCHEMA_IMPORTS).booleanValue()) {
            return EMPTY_SOURCE_ARRAY;
        }
        if ("http://www.w3.org/2005/xpath-functions".equals(targetNamespace)) {
            return new Source[]{StandardSchemaResolver.fetchResource("xpath-functions.scm", this.config)};
        }
        if ("http://www.w3.org/1999/xlink".equals(targetNamespace)) {
            locations = null;
        }
        if ((locations == null || locations.length == 0) && targetNamespace != null && (source = this.resolveNamespaceURI(targetNamespace, baseURI)) != null) {
            return new Source[]{source};
        }
        if (locations == null || locations.length == 0) {
            return EMPTY_SOURCE_ARRAY;
        }
        try {
            Source[] sources = new Source[locations.length];
            for (int i = 0; i < locations.length; ++i) {
                sources[i] = this.resolveLocationHint(baseURI, locations[i]);
            }
            return sources;
        }
        catch (TransformerException e) {
            throw XPathException.makeXPathException(e);
        }
    }

    private Source resolveLocationHint(String baseURI, String location) throws XPathException {
        ResourceRequest rr = new ResourceRequest();
        rr.relativeUri = location;
        rr.baseUri = baseURI;
        rr.nature = "http://www.w3.org/2001/XMLSchema";
        rr.purpose = "http://www.rddl.org/purposes#validation";
        try {
            rr.uri = ResolveURI.makeAbsolute(location, baseURI).toString();
        }
        catch (URISyntaxException err) {
            throw new XPathException("Unable to reserve schemaLocation URI " + location, err);
        }
        return rr.resolve(this.config.getResourceResolver(), new DirectResourceResolver(this.config));
    }

    private Source resolveNamespaceURI(String moduleURI, String baseURI) {
        ResourceRequest rr = new ResourceRequest();
        rr.uri = moduleURI;
        rr.baseUri = baseURI;
        rr.uriIsNamespace = true;
        rr.nature = "http://www.w3.org/2001/XMLSchema";
        rr.purpose = "http://www.rddl.org/purposes#validation";
        try {
            return rr.resolve(this.config.getResourceResolver());
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public static Source fetchResource(String pathName, Configuration config) {
        InputStream inputStream = Version.platform.locateResource(pathName, new ArrayList<String>());
        if (inputStream == null) {
            throw new AssertionError((Object)("Failed to load " + pathName + " from the Saxon library"));
        }
        if (config.isTiming()) {
            config.getLogger().info("Loading internal schema: " + pathName);
        }
        return new StreamSource(inputStream);
    }
}

