/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;

public class SortExpressionAdjunct
extends StreamingAdjunct {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        SortExpression exp = (SortExpression)this.getExpression();
        Expression sortInput = exp.getBaseExpression();
        PostureAndSweep basePS = Streamability.getStreamability(sortInput, contextInfo, new ArrayList<String>());
        if (basePS.getPosture() != Posture.GROUNDED) {
            reasons.add("A sort expression is not streamable unless the input sequence is grounded");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        ArrayList<Operand> expandedOperands = new ArrayList<Operand>();
        expandedOperands.add(exp.getBaseOperand());
        SortKeyDefinitionList skdl = exp.getSortKeyDefinitionList();
        for (SortKeyDefinition skd : skdl) {
            for (Operand o : skd.operands()) {
                expandedOperands.add(o);
            }
        }
        PostureAndSweep ps = Streamability.generalStreamabilityRules(this.getExpression(), expandedOperands, contextInfo, reasons);
        if (ps.getSweep() == Sweep.MOTIONLESS || ps.getSweep() == Sweep.CONSUMING) {
            Streamability.setPostureAndSweep(skdl, PostureAndSweep.GROUNDED_AND_MOTIONLESS);
            for (SortKeyDefinition skd : skdl) {
                Streamability.setPostureAndSweep(skd, PostureAndSweep.GROUNDED_AND_MOTIONLESS);
            }
        }
        return ps;
    }
}

