/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.trans.Characteristic;
import com.saxonica.ee.trans.PatternOptimizer;
import com.saxonica.ee.trans.Precondition;
import com.saxonica.ee.trans.RuleEE;
import com.saxonica.ee.trans.TokenMatchOperand;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.functions.Contains;
import net.sf.saxon.pattern.BasePatternWithPredicate;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternWithPredicate;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.value.Whitespace;

public class ContainsTokenPatternOptimizer
extends PatternOptimizer {
    private static final ContainsTokenPatternOptimizer THE_INSTANCE = new ContainsTokenPatternOptimizer();

    public static ContainsTokenPatternOptimizer getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public boolean appliesTo(Pattern pattern) {
        SystemFunctionCall call;
        Expression exp;
        if (pattern instanceof PatternWithPredicate && (exp = ((PatternWithPredicate)((Object)pattern)).getPredicate()).isCallOn(Contains.class) && (call = (SystemFunctionCall)exp).getArity() == 2 && call.getArg(1) instanceof StringLiteral && exp.getRetainedStaticContext().getDefaultCollationName().equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            String contained = ((StringLiteral)call.getArg(1)).stringify();
            return contained.matches(" [^ ]+ ");
        }
        return false;
    }

    @Override
    public void process(RuleEE rule, Pattern pattern, Map<Precondition, List<RuleEE>> preconditions, Map<Characteristic, Characteristic> characteristics) {
        Expression exp = ((BasePatternWithPredicate)pattern).getPredicate();
        SystemFunctionCall call = (SystemFunctionCall)exp;
        UnicodeString contained = ((StringLiteral)call.getArg(1)).getString();
        UnicodeString token = Whitespace.trim(contained);
        TokenMatchOperand chic = new TokenMatchOperand(call.getArg(0));
        chic = (TokenMatchOperand)this.allocateCharacteristic(characteristics, chic);
        CodepointCollator collator = CodepointCollator.getInstance();
        AtomicMatchKey key = collator.getCollationKey(token);
        Precondition.StringHashPrecondition p = new Precondition.StringHashPrecondition(chic, key, collator);
        this.addPrecondition(rule, preconditions, p);
    }
}

