/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserSchemaComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

public class Wildcard
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent,
Term {
    private Set<String> allowedNamespaces = null;
    private Set<String> disallowedNamespaces = null;
    private String processContents = "strict";
    private boolean disallowsDefinedNames = false;
    private boolean disallowsDefinedSiblings = false;
    private IntSet disallowedQNames;

    public boolean isInexpressible() {
        return false;
    }

    public final boolean allowsAny() {
        return this.allowedNamespaces == null && this.disallowedNamespaces == null;
    }

    public void setNoNamespacesAllowed() {
        this.allowedNamespaces = new HashSet<String>(3);
    }

    public void addAllowedNamespace(String namespace) {
        if (this.allowedNamespaces == null) {
            this.allowedNamespaces = new HashSet<String>(3);
        }
        this.allowedNamespaces.add(namespace);
    }

    public void addDisallowedNamespace(String namespace) {
        if (this.disallowedNamespaces == null) {
            this.disallowedNamespaces = new HashSet<String>(3);
        }
        this.disallowedNamespaces.add(namespace);
    }

    public Set<String> getDisallowedNamespaces() {
        return this.disallowedNamespaces;
    }

    public boolean matches(String uri) {
        if (this.allowedNamespaces != null) {
            return this.allowedNamespaces.contains(uri);
        }
        return this.disallowedNamespaces == null || !this.disallowedNamespaces.contains(uri);
    }

    public boolean matches(StructuredQName name, boolean isElement, Configuration config, UserComplexType parentType) {
        FingerprintedQName nn = new FingerprintedQName(name, config.getNamePool());
        return this.matches(nn, isElement, config, parentType);
    }

    public boolean matches(int fp, boolean isElement, Configuration config, UserComplexType parentType) {
        CodedName nn = new CodedName(fp, "", config.getNamePool());
        return this.matches(nn, isElement, config, parentType);
    }

    public boolean matches(NodeName name, boolean isElement, Configuration config, UserComplexType parentType) {
        int fingerprint = -1;
        if (this.disallowedQNames != null && this.disallowedQNames.contains(fingerprint)) {
            return false;
        }
        if (this.disallowedQNames != null && this.disallowedQNames.contains(fingerprint = name.obtainFingerprint(config.getNamePool()))) {
            return false;
        }
        if (this.disallowsDefinedNames) {
            if (fingerprint == -1) {
                fingerprint = name.obtainFingerprint(config.getNamePool());
            }
            if ((isElement ? config.getElementDeclaration(fingerprint) : config.getAttributeDeclaration(fingerprint)) != null) {
                return false;
            }
        }
        if (parentType != null && this.disallowsDefinedSiblings) {
            IntHashSet siblings = new IntHashSet();
            try {
                parentType.gatherAllPermittedChildren(siblings, true);
            }
            catch (SchemaException e) {
                throw new IllegalStateException(e);
            }
            if (siblings.contains(name.getFingerprint())) {
                return false;
            }
        }
        if (this.allowedNamespaces != null) {
            return this.allowedNamespaces.contains(name.getURI());
        }
        return this.disallowedNamespaces == null || !this.disallowedNamespaces.contains(name.getURI());
    }

    public String reasonForNonMatch(NodeName nn, boolean isElement, Configuration config, UserComplexType parentType) {
        int fingerprint = nn.obtainFingerprint(config.getNamePool());
        if (this.disallowedQNames != null && this.disallowedQNames.contains(fingerprint)) {
            return "The name is in the list of disallowed QNames for the wildcard. ";
        }
        if (this.disallowsDefinedNames && (isElement ? config.getElementDeclaration(fingerprint) : config.getAttributeDeclaration(fingerprint)) != null) {
            return "There is a global " + (isElement ? "element" : "attribute") + " declaration for the name, and the wildcard specifies notQName='##defined'. ";
        }
        if (parentType != null && this.disallowsDefinedSiblings) {
            IntHashSet siblings = new IntHashSet();
            try {
                parentType.gatherAllPermittedChildren(siblings, true);
            }
            catch (SchemaException e) {
                throw new IllegalStateException(e);
            }
            if (siblings.contains(nn.getFingerprint())) {
                return "The wildcard disallows defined siblings, and the name is a permitted sibling. ";
            }
        }
        String uri = nn.getURI();
        if (this.allowedNamespaces != null) {
            if (this.allowedNamespaces.contains(uri)) {
                return null;
            }
            return "The name is not in one of the permitted namespaces for the wildcard. ";
        }
        if (this.disallowedNamespaces == null || !this.disallowedNamespaces.contains(uri)) {
            return null;
        }
        return "The name is in " + (this.disallowedNamespaces.size() == 1 ? "the disallowed namespace" : "one of the disallowed namespaces") + " for the wildcard. ";
    }

    public boolean disallowsQName(int fingerprint) {
        return this.disallowedQNames != null && this.disallowedQNames.contains(fingerprint);
    }

    public Set<String> getAllowedNamespaces() {
        return this.allowedNamespaces;
    }

    public String getProcessContents() {
        return this.processContents;
    }

    public void setProcessContents(String process) {
        this.processContents = process;
    }

    public void setDisallowDefinedNames(boolean disallow) {
        this.disallowsDefinedNames = disallow;
    }

    public boolean isDisallowDefinedNames() {
        return this.disallowsDefinedNames;
    }

    public void setDisallowDefinedSiblings(boolean disallow) {
        this.disallowsDefinedSiblings = disallow;
    }

    public boolean isDisallowDefinedSiblings() {
        return this.disallowsDefinedSiblings;
    }

    public void addDisallowedQName(int fingerprint) {
        if (this.disallowedQNames == null) {
            this.disallowedQNames = new IntHashSet(10);
        }
        this.disallowedQNames.add(fingerprint);
    }

    public boolean isDisallowedQName(int fingerprint) {
        return this.disallowedQNames != null && this.disallowedQNames.contains(fingerprint);
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        return true;
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        if (this.disallowedNamespaces != null) {
            fsb.append("not{");
            this.appendNamespaces(this.disallowedNamespaces, fsb);
            fsb.append("}");
        } else if (this.allowedNamespaces != null) {
            fsb.append("anyOf{");
            this.appendNamespaces(this.allowedNamespaces, fsb);
            fsb.append("}");
        } else {
            fsb.append("any");
        }
        if (this.disallowsDefinedSiblings && this.disallowedQNames != null) {
            fsb.append(" except defined siblings and other specific names");
        }
        if (this.disallowsDefinedSiblings) {
            fsb.append(" except defined siblings");
        }
        if (this.disallowedQNames != null) {
            int nr = this.disallowedQNames.size();
            if (nr == 1) {
                fsb.append(" except one specific name");
            } else {
                fsb.append(" except " + nr + " specific names");
            }
        }
        return fsb.toString();
    }

    private void appendNamespaces(Set<String> namespaces, FastStringBuffer sb) {
        if (namespaces == null) {
            return;
        }
        Iterator<String> iter = namespaces.iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            String s = iter.next();
            sb.append(s.isEmpty() ? "##local" : s);
        }
    }

    private String listOfNamespaces(Set<String> namespaces) {
        if (namespaces == null) {
            return "";
        }
        FastStringBuffer sb = new FastStringBuffer(64);
        this.appendNamespaces(namespaces, sb);
        return sb.toString();
    }

    public boolean isSubset(Wildcard sup, NamePool pool) {
        if (!this.isNamespaceSubset(sup)) {
            return false;
        }
        if (sup.disallowedQNames != null) {
            IntIterator it = sup.disallowedQNames.iterator();
            while (it.hasNext()) {
                int fp = it.next();
                String uri = pool.getURI(fp);
                if (!this.matches(uri) || this.disallowsQName(fp)) continue;
                return false;
            }
        }
        return !sup.disallowsDefinedNames || this.disallowsDefinedNames;
    }

    private boolean isNamespaceSubset(Wildcard sup) {
        if (sup.allowedNamespaces == null && sup.disallowedNamespaces == null) {
            return true;
        }
        if (sup.allowedNamespaces != null && this.allowedNamespaces != null) {
            return sup.allowedNamespaces.containsAll(this.allowedNamespaces);
        }
        if (this.allowedNamespaces != null && sup.disallowedNamespaces != null) {
            return Collections.disjoint(this.allowedNamespaces, sup.disallowedNamespaces);
        }
        if (sup.disallowedNamespaces != null && this.disallowedNamespaces != null) {
            return this.disallowedNamespaces.containsAll(sup.disallowedNamespaces);
        }
        return false;
    }

    public boolean overlaps(Wildcard other) {
        if (this.allowedNamespaces == null && this.disallowedNamespaces == null) {
            return true;
        }
        if (other.allowedNamespaces == null && other.disallowedNamespaces == null) {
            return true;
        }
        if (this.disallowedNamespaces != null && other.disallowedNamespaces != null) {
            return true;
        }
        if (this.disallowedNamespaces != null && other.allowedNamespaces != null) {
            return !this.disallowedNamespaces.containsAll(other.allowedNamespaces);
        }
        if (other.disallowedNamespaces != null && this.allowedNamespaces != null) {
            return !other.disallowedNamespaces.containsAll(this.allowedNamespaces);
        }
        if (this.allowedNamespaces != null && other.allowedNamespaces != null) {
            return !Collections.disjoint(this.allowedNamespaces, other.allowedNamespaces);
        }
        return true;
    }

    public static boolean isNotStronger(String str1, String str2) {
        int r2;
        String ranking = "skip lax strict";
        int r1 = ranking.indexOf(str1);
        return r1 <= (r2 = ranking.indexOf(str2));
    }

    public int compareStrength(Wildcard other) {
        String ranking = "skip lax strict";
        int r1 = ranking.indexOf(this.processContents);
        int r2 = ranking.indexOf(other.processContents);
        return Integer.valueOf(r1).compareTo(r2);
    }

    public static Wildcard makeIntersection(Wildcard wat1, Wildcard wat2, NamePool pool) {
        String uri;
        int fp;
        IntIterator it;
        Set<String> allowed1 = wat1.getAllowedNamespaces();
        Set<String> allowed2 = wat2.getAllowedNamespaces();
        Set<String> disallowed1 = wat1.getDisallowedNamespaces();
        Set<String> disallowed2 = wat2.getDisallowedNamespaces();
        Wildcard result = new Wildcard();
        result.setConfiguration(wat1.getConfiguration());
        result.setProcessContents(wat1.getProcessContents());
        result.setLocator(wat1);
        if (allowed1 != null && allowed2 != null) {
            result.allowedNamespaces = Wildcard.intersection(allowed1, allowed2);
        } else if (disallowed1 != null && disallowed2 != null) {
            result.disallowedNamespaces = Wildcard.union(disallowed1, disallowed2);
        } else if (allowed1 == null && disallowed1 == null) {
            result.allowedNamespaces = allowed2;
            result.disallowedNamespaces = disallowed2;
        } else if (allowed2 == null && disallowed2 == null) {
            result.allowedNamespaces = allowed1;
            result.disallowedNamespaces = disallowed1;
        } else if (allowed1 != null && disallowed2 != null) {
            result.allowedNamespaces = Wildcard.difference(allowed1, disallowed2);
        } else if (allowed2 != null && disallowed1 != null) {
            result.allowedNamespaces = Wildcard.difference(allowed2, disallowed1);
        } else {
            throw new IllegalStateException("Invalid wildcard");
        }
        if (result.disallowedNamespaces != null && result.disallowedNamespaces.isEmpty()) {
            result.disallowedNamespaces = null;
        }
        if (wat1.disallowedQNames != null) {
            it = wat1.disallowedQNames.iterator();
            while (it.hasNext()) {
                fp = it.next();
                uri = pool.getURI(fp);
                if (!wat2.matches(uri)) continue;
                result.addDisallowedQName(fp);
            }
        }
        if (wat2.disallowedQNames != null) {
            it = wat2.disallowedQNames.iterator();
            while (it.hasNext()) {
                fp = it.next();
                uri = pool.getURI(fp);
                if (!wat1.matches(uri)) continue;
                result.addDisallowedQName(fp);
            }
        }
        if (wat1.disallowsDefinedNames || wat2.disallowsDefinedNames) {
            result.disallowsDefinedNames = true;
        }
        return result;
    }

    public static Wildcard makeUnion(Wildcard wat1, Wildcard wat2, NamePool pool) {
        String uri;
        int fp;
        IntIterator it;
        Set<String> allowed1 = wat1.getAllowedNamespaces();
        Set<String> allowed2 = wat2.getAllowedNamespaces();
        Set<String> disallowed1 = wat1.getDisallowedNamespaces();
        Set<String> disallowed2 = wat2.getDisallowedNamespaces();
        Wildcard result = new Wildcard();
        result.setConfiguration(wat1.getConfiguration());
        result.setProcessContents(wat1.getProcessContents());
        result.setLocator(wat1);
        if (allowed1 != null && allowed2 != null) {
            result.allowedNamespaces = Wildcard.union(allowed1, allowed2);
        } else if (disallowed1 != null && disallowed2 != null) {
            result.disallowedNamespaces = Wildcard.intersection(disallowed1, disallowed2);
        } else if (allowed1 == null && disallowed1 == null) {
            result.allowedNamespaces = null;
            result.disallowedNamespaces = null;
        } else if (allowed2 == null && disallowed2 == null) {
            result.allowedNamespaces = null;
            result.disallowedNamespaces = null;
        } else if (allowed1 != null && disallowed2 != null) {
            result.disallowedNamespaces = Wildcard.difference(disallowed2, allowed1);
        } else if (allowed2 != null && disallowed1 != null) {
            result.disallowedNamespaces = Wildcard.difference(disallowed1, allowed2);
        } else {
            throw new IllegalStateException("Invalid wildcard");
        }
        if (result.allowedNamespaces != null && result.allowedNamespaces.isEmpty()) {
            result.allowedNamespaces = null;
        }
        if (result.disallowedNamespaces != null && result.disallowedNamespaces.isEmpty()) {
            result.disallowedNamespaces = null;
        }
        if (wat1.disallowedQNames != null) {
            it = wat1.disallowedQNames.iterator();
            while (it.hasNext()) {
                fp = it.next();
                uri = pool.getURI(fp);
                if (wat2.matches(uri) && !wat2.disallowsQName(fp)) continue;
                result.addDisallowedQName(fp);
            }
        }
        if (wat2.disallowedQNames != null) {
            it = wat2.disallowedQNames.iterator();
            while (it.hasNext()) {
                fp = it.next();
                uri = pool.getURI(fp);
                if (wat1.matches(uri) && !wat1.disallowsQName(fp)) continue;
                result.addDisallowedQName(fp);
            }
        }
        if (wat1.disallowsDefinedNames && wat2.disallowsDefinedNames) {
            result.disallowsDefinedNames = true;
        }
        return result;
    }

    private static Set<String> union(Set<String> a, Set<String> b) {
        HashSet<String> result = new HashSet<String>(a.size() + b.size());
        for (String s : a) {
            result.add(s);
        }
        for (String s : b) {
            result.add(s);
        }
        return result;
    }

    private static Set<String> intersection(Set<String> a, Set<String> b) {
        HashSet<String> result = new HashSet<String>();
        for (String s : a) {
            if (!b.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    private static Set<String> difference(Set<String> a, Set<String> b) {
        HashSet<String> result = new HashSet<String>();
        for (String s : a) {
            if (b.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("wildcard");
        serializer.emitAttribute("id", serializer.getId(this, true));
        serializer.emitAttribute("processContents", this.getProcessContents());
        if (this.allowedNamespaces == null) {
            if (this.disallowedNamespaces == null) {
                serializer.emitAttribute("constraint", "any");
            } else {
                serializer.emitAttribute("constraint", "not");
                serializer.emitAttribute("namespaces", this.listOfNamespaces(this.disallowedNamespaces));
            }
        } else {
            serializer.emitAttribute("constraint", "enumeration");
            serializer.emitAttribute("namespaces", this.listOfNamespaces(this.allowedNamespaces));
        }
        FastStringBuffer disallowedNames = new FastStringBuffer(100);
        if (this.disallowsDefinedNames) {
            disallowedNames.append("##defined ");
        }
        if (this.disallowsDefinedSiblings) {
            disallowedNames.append("##definedSibling ");
        }
        if (this.disallowedQNames != null && !this.disallowedQNames.isEmpty()) {
            NamePool pool = this.getConfiguration().getNamePool();
            IntIterator intit = this.disallowedQNames.iterator();
            while (intit.hasNext()) {
                int nc = intit.next();
                String name = pool.getClarkName(nc);
                disallowedNames.append(name);
                disallowedNames.append(' ');
            }
        }
        if (disallowedNames.length() > 0) {
            disallowedNames.setLength(disallowedNames.length() - 1);
            serializer.emitAttribute("notQName", disallowedNames.toString());
        }
        serializer.endElement();
    }

    @Override
    public Function getComponentAsFunction() {
        Callable callable = new Callable(){

            public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
                String key;
                switch (key = arguments[0].head().getStringValue()) {
                    case "class": {
                        return new StringValue("Wildcard");
                    }
                    case "implementation": {
                        return new ObjectValue<Wildcard>(Wildcard.this);
                    }
                    case "namespace constraint": {
                        Callable constraintFunction = new Callable(){

                            public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
                                String key;
                                switch (key = arguments[0].head().getStringValue()) {
                                    case "class": {
                                        return new StringValue("Namespace Constraint");
                                    }
                                    case "variety": {
                                        if (Wildcard.this.allowsAny()) {
                                            return new StringValue("any");
                                        }
                                        if (Wildcard.this.allowedNamespaces != null) {
                                            return new StringValue("enumeration");
                                        }
                                        return new StringValue("not");
                                    }
                                    case "namespaces": {
                                        if (Wildcard.this.allowsAny()) {
                                            return EmptySequence.getInstance();
                                        }
                                        Set namespaces = Wildcard.this.allowedNamespaces != null ? Wildcard.this.allowedNamespaces : Wildcard.this.disallowedNamespaces;
                                        ArrayList<AnyURIValue> list = new ArrayList<AnyURIValue>(namespaces.size());
                                        for (String ns : namespaces) {
                                            list.add(new AnyURIValue(ns));
                                        }
                                        return SequenceExtent.makeSequenceExtent(list);
                                    }
                                    case "disallowed names": {
                                        ArrayList<AtomicValue> list = new ArrayList<AtomicValue>();
                                        if (Wildcard.this.disallowsDefinedNames) {
                                            list.add(new StringValue("defined"));
                                        }
                                        if (Wildcard.this.disallowsDefinedSiblings) {
                                            list.add(new StringValue("definedSiblings"));
                                        }
                                        NamePool pool = Wildcard.this.getConfiguration().getNamePool();
                                        IntIterator iter = Wildcard.this.disallowedQNames.iterator();
                                        while (iter.hasNext()) {
                                            int fp = iter.next();
                                            String uri = pool.getURI(fp);
                                            String local = pool.getLocalName(fp);
                                            QNameValue value = new QNameValue("", uri, local);
                                            list.add(value);
                                        }
                                        return SequenceExtent.makeSequenceExtent(list);
                                    }
                                }
                                return EmptySequence.getInstance();
                            }
                        };
                        return new CallableFunction(1, constraintFunction, SchemaComponent.COMPONENT_FUNCTION_TYPE);
                    }
                    case "process contents": {
                        return new StringValue(Wildcard.this.getProcessContents());
                    }
                }
                return EmptySequence.getInstance();
            }
        };
        return new CallableFunction(1, callable, COMPONENT_FUNCTION_TYPE);
    }
}

