/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.expr.sort.UcaCollatorUsingIcu;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;

public class ICULibrary {
    private static boolean ICUCollatorAvailable;
    private static boolean ICUNumbererAvailable;

    public static boolean isICUCollatorAvailable() {
        return ICUCollatorAvailable;
    }

    public static boolean hasNumberer() {
        return ICUNumbererAvailable;
    }

    public static StringCollator makeICUCollator(String uri, Configuration config) throws XPathException {
        if (config.isLicensedFeature(8) && ICULibrary.isICUCollatorAvailable()) {
            return new UcaCollatorUsingIcu(uri);
        }
        return null;
    }

    public static String getLanguageTag(Locale locale) {
        try {
            Method m = Locale.class.getMethod("toLanguageTag", new Class[0]);
            return (String)m.invoke((Object)locale, new Object[0]);
        }
        catch (NoSuchMethodException m) {
        }
        catch (IllegalAccessException m) {
        }
        catch (InvocationTargetException m) {
            // empty catch block
        }
        String rep = locale.toString();
        int firstUnderscore = rep.indexOf(95);
        if (firstUnderscore < 0) {
            return rep;
        }
        int secondUnderscore = rep.indexOf(95, firstUnderscore + 1);
        if (secondUnderscore < 0) {
            return rep.replace('_', '-');
        }
        return rep.substring(0, secondUnderscore).replace('_', '-');
    }

    static {
        Class<?> t;
        ICUCollatorAvailable = false;
        ICUNumbererAvailable = false;
        try {
            t = Class.forName("com.ibm.icu.text.RuleBasedCollator");
            ICUCollatorAvailable = true;
        }
        catch (ClassNotFoundException e) {
            ICUCollatorAvailable = false;
        }
        try {
            t = Class.forName("com.ibm.icu.text.RuleBasedNumberFormat");
            ICUNumbererAvailable = true;
        }
        catch (ClassNotFoundException e) {
            ICUNumbererAvailable = false;
        }
    }
}

