/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.Callback;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.expr.JavaExtensionFunctionCall;
import com.saxonica.objectweb.asm.Type;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.IntegratedFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;

public class JavaExtensionFunctionCallCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        JavaExtensionFunctionCall jefc = (JavaExtensionFunctionCall)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        JavaExtensionFunctionCallCompiler.visitAnnotation(compiler, "JavaExtensionFunctionCallCompiler-Itr " + jefc.getDisplayName());
        JavaExtensionFunctionCallCompiler.visitLineNumber(compiler, ga, expression);
        boolean resultConverterOnStack = false;
        JPConverter resultConverter = jefc.getResultConverter();
        if (!SequenceIterator.class.isAssignableFrom(jefc.getReturnClass()) && !jefc.getReturnClass().isPrimitive()) {
            resultConverterOnStack = true;
            JavaExtensionFunctionCallCompiler.allocateStatic(compiler, resultConverter);
        }
        this.compileToObject(compiler, expression);
        LabelInfo nonNullResult = methodInfo.newLabel("nonNullResult");
        LabelInfo end = methodInfo.newLabel("endJEFC");
        if (jefc.getReturnClass() == Void.TYPE && !jefc.isReturnVoidAsThis()) {
            ga.invokeStaticMethod(EmptyIterator.class, "getInstance", new Class[0]);
            ga.checkClass(SequenceIterator.class);
        } else if (jefc.getReturnClass().isPrimitive()) {
            if (jefc.getReturnClass() == Integer.TYPE) {
                ga.cast(Type.INT_TYPE, Type.LONG_TYPE);
                ga.invokeStaticMethod(Int64Value.class, "makeIntegerValue", Long.TYPE);
            } else if (jefc.getReturnClass() == Boolean.TYPE) {
                ga.invokeStaticMethod(BooleanValue.class, "get", Boolean.TYPE);
            } else if (jefc.getReturnClass() == Long.TYPE) {
                ga.invokeStaticMethod(Int64Value.class, "makeIntegerValue", Long.TYPE);
            } else if (jefc.getReturnClass() == Short.TYPE) {
                ga.cast(Type.SHORT_TYPE, Type.LONG_TYPE);
                ga.invokeStaticMethod(Int64Value.class, "makeIntegerValue", Long.TYPE);
            } else if (jefc.getReturnClass() == Byte.TYPE) {
                ga.cast(Type.BYTE_TYPE, Type.LONG_TYPE);
                ga.invokeStaticMethod(Int64Value.class, "makeIntegerValue", Long.TYPE);
            } else if (jefc.getReturnClass() == Character.TYPE) {
                ga.invokeStaticMethod(Character.class, "toString", Character.TYPE);
                ga.invokeStaticMethod(StringValue.class, "makeStringValue", CharSequence.class);
            } else if (jefc.getReturnClass() == Float.TYPE) {
                ga.invokeStaticMethod(FloatValue.class, "makeFloatValue", Float.TYPE);
            } else if (jefc.getReturnClass() == Double.TYPE) {
                ga.invokeStaticMethod(DoubleValue.class, "makeDoubleValue", Double.TYPE);
            } else {
                throw new IllegalStateException();
            }
            ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
        } else {
            ga.dup();
            ga.ifNonNull(nonNullResult.label());
            ga.pop();
            if (resultConverterOnStack) {
                ga.pop();
            }
            ga.invokeStaticMethod(EmptyIterator.class, "getInstance", new Class[0]);
            ga.checkClass(SequenceIterator.class);
            ga.goTo(end);
            methodInfo.placeLabel(nonNullResult);
            if (SequenceIterator.class.isAssignableFrom(jefc.getReturnClass())) {
                ga.checkClass(SequenceIterator.class);
            } else {
                compiler.generateGetContext();
                ga.invokeInstanceMethod(JPConverter.class, "convert", Object.class, XPathContext.class);
                ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
            }
            if (jefc.isNodeCheckRequired()) {
                int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
                ga.storeLocal(iterVar);
                ga.newInstance(ItemMappingIterator.class);
                ga.dup();
                ga.loadLocal(iterVar);
                ga.newInstance(IntegratedFunctionCall.ConfigurationCheckingFunction.class);
                ga.dup();
                compiler.generateGetContext();
                ga.invokeInstanceMethod(XPathContext.class, "getConfiguration", new Class[0]);
                ga.invokeConstructor(IntegratedFunctionCall.ConfigurationCheckingFunction.class, Configuration.class);
                ga.push(true);
                ga.invokeConstructor(ItemMappingIterator.class, SequenceIterator.class, ItemMappingFunction.class, Boolean.TYPE);
                methodInfo.releaseLocal(iterVar);
            }
        }
        methodInfo.placeLabel(end);
    }

    private void compileToObject(CompilerService compiler, Expression expression) throws CannotCompileException {
        JavaExtensionFunctionCall jefc = (JavaExtensionFunctionCall)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        LabelInfo enterTry = mi.newLabel("enterTry");
        LabelInfo leaveTry = mi.newLabel("leaveTry");
        LabelInfo enterCatch = mi.newLabel("enterCatch");
        LabelInfo leaveCatch = mi.newLabel("leaveCatch");
        Class theClass = jefc.getTargetClass();
        AccessibleObject theMethod = jefc.getTargetMethod();
        if (theMethod instanceof Method || theMethod instanceof Constructor) {
            ga.visitTryCatchBlock(enterTry, leaveTry, enterCatch, "java/lang/Exception");
        }
        if (theMethod instanceof Constructor) {
            ga.newInstance(Type.getType(theClass));
            ga.dup();
            this.stackConvertedArguments(compiler, ga, jefc, false, true, -1);
            mi.placeLabel(enterTry);
            ga.invokeConstructor(theClass, jefc.getParameterTypes());
            mi.placeLabel(leaveTry);
            ga.goTo(leaveCatch);
            mi.placeLabel(enterCatch);
            JavaExtensionFunctionCallCompiler.allocateStatic(compiler, jefc);
            ga.invokeStaticMethod(Callback.class, "makeJavaInvocationException", Exception.class, JavaExtensionFunctionCall.class);
            ga.throwException();
            mi.placeLabel(leaveCatch);
        } else if (theMethod instanceof Method) {
            boolean usesContext;
            boolean isStatic = Modifier.isStatic(((Method)theMethod).getModifiers());
            int instanceVar = -1;
            if (((Method)theMethod).getReturnType() == Void.TYPE && jefc.isReturnVoidAsThis()) {
                instanceVar = ga.newLocal(theClass);
            }
            boolean bl = usesContext = jefc.getParameterTypes().length > 0 && jefc.getParameterTypes()[0] == XPathContext.class;
            if (usesContext) {
                if (isStatic) {
                    this.stackConvertedArguments(compiler, ga, jefc, true, true, instanceVar);
                    mi.placeLabel(enterTry);
                    ga.invokeStaticMethod(theClass, ((Method)theMethod).getName(), jefc.getParameterTypes());
                    mi.placeLabel(leaveTry);
                } else {
                    this.stackConvertedArguments(compiler, ga, jefc, true, false, instanceVar);
                    mi.placeLabel(enterTry);
                    ga.invokeInstanceMethod(theClass, ((Method)theMethod).getName(), jefc.getParameterTypes());
                    mi.placeLabel(leaveTry);
                }
            } else if (isStatic) {
                this.stackConvertedArguments(compiler, ga, jefc, false, true, instanceVar);
                mi.placeLabel(enterTry);
                ga.invokeStaticMethod(theClass, ((Method)theMethod).getName(), jefc.getParameterTypes());
                mi.placeLabel(leaveTry);
            } else {
                this.stackConvertedArguments(compiler, ga, jefc, false, false, instanceVar);
                mi.placeLabel(enterTry);
                ga.invokeInstanceMethod(theClass, ((Method)theMethod).getName(), jefc.getParameterTypes());
                mi.placeLabel(leaveTry);
            }
            ga.goTo(leaveCatch);
            mi.placeLabel(enterCatch);
            JavaExtensionFunctionCallCompiler.allocateStatic(compiler, jefc);
            ga.invokeStaticMethod(Callback.class, "makeJavaInvocationException", Exception.class, JavaExtensionFunctionCall.class);
            ga.throwException();
            mi.placeLabel(leaveCatch);
            if (instanceVar >= 0) {
                ga.loadLocal(instanceVar);
            }
        } else if (theMethod instanceof Field) {
            Field field = (Field)theMethod;
            boolean isStatic = Modifier.isStatic(field.getModifiers());
            if (isStatic) {
                ga.getStaticField(theClass, field.getName(), field.getType());
            } else {
                this.stackConvertedArguments(compiler, ga, jefc, false, false, -1);
                ga.getInstanceField(theClass, field.getName());
            }
        }
    }

    private void stackConvertedArguments(CompilerService compiler, Generator ga, JavaExtensionFunctionCall jfc, boolean usesContext, boolean isStatic, int instanceVar) throws CannotCompileException {
        int offset = 0;
        for (int i = 0; i < jfc.getArity(); ++i) {
            Class requiredClass;
            if (usesContext && i == (isStatic ? 0 : 1)) {
                compiler.generateGetContext();
                ++offset;
            }
            PJConverter converter = jfc.getArgumentConverters()[i];
            if (i == 0 && !isStatic) {
                requiredClass = jfc.getTargetClass();
                --offset;
            } else {
                requiredClass = jfc.getParameterTypes()[i + offset];
            }
            if (!(converter instanceof PJConverter.Identity)) {
                boolean done = false;
                if (jfc.getArg(i) instanceof Literal) {
                    try {
                        Object obj = converter.convert(((Literal)jfc.getArg(i)).getValue(), requiredClass, null);
                        JavaExtensionFunctionCallCompiler.allocateStatic(compiler, obj);
                        done = true;
                    }
                    catch (Exception err) {
                        done = false;
                    }
                }
                if (!done) {
                    JavaExtensionFunctionCallCompiler.allocateStatic(compiler, converter);
                    compiler.compileToSequence(jfc.getArg(i));
                    JavaExtensionFunctionCallCompiler.allocateStatic(compiler, requiredClass);
                    compiler.generateGetContext();
                    ga.invokeInstanceMethod(PJConverter.class, "convert", Sequence.class, Class.class, XPathContext.class);
                }
                if (i == 0 && !isStatic && instanceVar >= 0) {
                    ga.dup();
                    ga.storeLocal(instanceVar);
                }
                if (requiredClass.isPrimitive()) {
                    this.unbox(ga, requiredClass);
                    continue;
                }
                ga.checkClass(requiredClass);
                continue;
            }
            if (requiredClass == Item.class) {
                compiler.compileToItem(jfc.getArg(i));
                ga.checkClass(requiredClass);
                continue;
            }
            JavaExtensionFunctionCallCompiler.allocateStatic(compiler, converter);
            compiler.compileToSequence(jfc.getArg(i));
            JavaExtensionFunctionCallCompiler.allocateStatic(compiler, requiredClass);
            compiler.generateGetContext();
            ga.invokeInstanceMethod(PJConverter.class, "convert", Sequence.class, Class.class, XPathContext.class);
            ga.checkClass(requiredClass);
        }
        if (usesContext && jfc.getArity() == (isStatic ? 0 : 1)) {
            compiler.generateGetContext();
        }
    }

    private void unbox(Generator ga, Class requiredClass) {
        if (requiredClass == Integer.TYPE) {
            ga.checkClass(Integer.class);
            ga.invokeInstanceMethod(Integer.class, "intValue", new Class[0]);
        } else if (requiredClass == Boolean.TYPE) {
            ga.checkClass(Boolean.class);
            ga.invokeInstanceMethod(Boolean.class, "booleanValue", new Class[0]);
        } else if (requiredClass == Long.TYPE) {
            ga.checkClass(Long.class);
            ga.invokeInstanceMethod(Long.class, "longValue", new Class[0]);
        } else if (requiredClass == Short.TYPE) {
            ga.checkClass(Short.class);
            ga.invokeInstanceMethod(Short.class, "shortValue", new Class[0]);
        } else if (requiredClass == Byte.TYPE) {
            ga.checkClass(Byte.class);
            ga.invokeInstanceMethod(Byte.class, "byteValue", new Class[0]);
        } else if (requiredClass == Character.TYPE) {
            ga.checkClass(Character.class);
            ga.invokeInstanceMethod(Character.class, "charValue", new Class[0]);
        } else if (requiredClass == Float.TYPE) {
            ga.checkClass(Float.class);
            ga.invokeInstanceMethod(Float.class, "floatValue", new Class[0]);
        } else if (requiredClass == Double.TYPE) {
            ga.checkClass(Double.class);
            ga.invokeInstanceMethod(Double.class, "doubleValue", new Class[0]);
        } else {
            throw new IllegalStateException();
        }
    }
}

