/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.AxisExpressionCompiler;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.Cardinality;

public class SimpleStepExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression start = ((SlashExpression)expression).getSelectExpression();
        Expression step = ((SlashExpression)expression).getActionExpression();
        byte axis = ((AxisExpression)step).getAxis();
        NodeTest test = ((AxisExpression)step).getNodeTest();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        SimpleStepExpressionCompiler.visitAnnotation(compiler, "SimpleStepExpression-Itr");
        SimpleStepExpressionCompiler.visitLineNumber(compiler, ga, expression);
        compiler.compileToItem(start);
        if (Cardinality.allowsZero(start.getCardinality())) {
            LabelInfo end = methodInfo.newLabel("endStep");
            LabelInfo notNull = methodInfo.newLabel("notnull");
            ga.dup();
            ga.ifNonNull(notNull.label());
            ga.pop();
            ga.invokeStaticMethod(EmptyIterator.class, "getInstance", new Class[0]);
            ga.goTo(end);
            methodInfo.placeLabel(notNull);
            ga.checkClass(NodeInfo.class);
            AxisExpressionCompiler.iterate(compiler, axis, test);
            methodInfo.placeLabel(end);
        } else {
            ga.checkClass(NodeInfo.class);
            AxisExpressionCompiler.iterate(compiler, axis, test);
        }
    }
}

