/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserUnionType;
import com.saxonica.ee.validate.ValidatingFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class EntityValidator
extends ValidatingFilter {
    private Set<String> declaredEntities = new HashSet<String>(10);
    private EntityChecker currentElementChecker = null;
    private FastStringBuffer buffer = new FastStringBuffer(64);
    private Location textLocationId = ExplicitLocation.UNKNOWN_LOCATION;
    private Map<SchemaType, EntityChecker> checkerMap = new HashMap<SchemaType, EntityChecker>(10);
    private static NonIdChecker SINGLETON_NON_ENTITY_CHECKER = new NonIdChecker();

    public EntityValidator(Receiver next) {
        super(next);
    }

    @Override
    public void setUnparsedEntity(String name, String uri, String publicId) throws XPathException {
        this.declaredEntities.add(name);
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.currentElementChecker = this.checkerMap.get(typeCode);
        if (this.currentElementChecker == null) {
            this.currentElementChecker = this.allocateChecker(typeCode);
            this.checkerMap.put(typeCode, this.currentElementChecker);
        }
        if (this.currentElementChecker == SINGLETON_NON_ENTITY_CHECKER) {
            this.currentElementChecker = null;
        }
        this.nextReceiver.startElement(nameCode, typeCode, location, properties);
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.currentElementChecker != null) {
            this.buffer.append(chars);
        }
        this.nextReceiver.characters(chars, locationId, properties);
        this.textLocationId = locationId.saveLocation();
    }

    @Override
    public void endElement() throws XPathException {
        if (this.currentElementChecker != null) {
            this.currentElementChecker.checkValue(this.buffer, this.textLocationId);
        }
        this.buffer.setLength(0);
        this.currentElementChecker = null;
        this.nextReceiver.endElement();
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        EntityChecker checker = this.checkerMap.get(typeCode);
        if (checker == null) {
            checker = this.allocateChecker(typeCode);
            this.checkerMap.put(typeCode, checker);
        }
        checker.checkValue(value, locationId);
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    private EntityChecker allocateChecker(SchemaType type) throws MissingComponentException {
        int fingerprint = type.getFingerprint();
        switch (fingerprint) {
            case 563: {
                return new SimpleEntityChecker();
            }
            case 564: {
                return new EntityListChecker();
            }
        }
        if (fingerprint < 1023) {
            return SINGLETON_NON_ENTITY_CHECKER;
        }
        Configuration config = this.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        if (type.isComplexType()) {
            return SINGLETON_NON_ENTITY_CHECKER;
        }
        SimpleType stype = (SimpleType)type;
        if (type.isAtomicType()) {
            if (th.isSubType((AtomicType)type, BuiltInAtomicType.ENTITY)) {
                return new SimpleEntityChecker();
            }
            return SINGLETON_NON_ENTITY_CHECKER;
        }
        if (stype.isListType()) {
            if (EntityValidator.isEntityType(stype, th)) {
                return new EntityListChecker();
            }
            return SINGLETON_NON_ENTITY_CHECKER;
        }
        if (EntityValidator.isEntityType(stype, th)) {
            return new UnionChecker(stype);
        }
        return SINGLETON_NON_ENTITY_CHECKER;
    }

    private static boolean isEntityType(SimpleType type, TypeHierarchy th) throws MissingComponentException {
        if (type.isAtomicType()) {
            return th.isSubType((AtomicType)type, BuiltInAtomicType.ENTITY);
        }
        if (type.isListType()) {
            return EntityValidator.isEntityType(((ListType)type).getItemType(), th);
        }
        if (type.isUnionType()) {
            UserUnionType union = (UserUnionType)type;
            for (TypeReference ref : union.getMemberTypeReferences()) {
                SimpleType mem = (SimpleType)ref.getTarget();
                if (!EntityValidator.isEntityType(mem, th)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    private void processEntityRef(String eref, Location locationId) throws XPathException {
        if (!this.declaredEntities.contains(eref)) {
            ValidationFailure ve = new ValidationFailure("Value '" + eref + "' is not declared in the DTD as an unparsed entity name");
            ve.setConstraintReference(1, "cvc-simple-type", "3");
            this.reportValidationError(ve, false, locationId);
            throw ve.makeException();
        }
    }

    private static class NonIdChecker
    implements EntityChecker {
        private NonIdChecker() {
        }

        @Override
        public void checkValue(CharSequence value, Location locationId) throws XPathException {
        }
    }

    private class UnionChecker
    implements EntityChecker {
        private SimpleType type;

        public UnionChecker(SimpleType type) {
            this.type = type;
        }

        @Override
        public void checkValue(CharSequence value, Location locationId) throws XPathException {
            AtomicValue val;
            Configuration config = EntityValidator.this.getConfiguration();
            TypeHierarchy th = config.getTypeHierarchy();
            AtomicIterator iter = this.type.getTypedValue(value, DummyNamespaceResolver.getInstance(), config.getConversionRules()).iterate();
            while ((val = (AtomicValue)iter.next()) != null) {
                AtomicType itemType = val.getItemType();
                if (!EntityValidator.isEntityType(itemType, th)) continue;
                EntityValidator.this.processEntityRef(val.getStringValue(), locationId);
            }
        }
    }

    private class EntityListChecker
    implements EntityChecker {
        private EntityListChecker() {
        }

        @Override
        public void checkValue(CharSequence value, Location locationId) throws XPathException {
            String ids = value.toString();
            StringTokenizer tok = new StringTokenizer(ids, " \t\n\r", false);
            while (tok.hasMoreTokens()) {
                String id = tok.nextToken();
                EntityValidator.this.processEntityRef(id, locationId);
            }
        }
    }

    private class SimpleEntityChecker
    implements EntityChecker {
        private SimpleEntityChecker() {
        }

        @Override
        public void checkValue(CharSequence value, Location locationId) throws XPathException {
            String id = Whitespace.trimWhitespace(value).toString();
            EntityValidator.this.processEntityRef(id, locationId);
        }
    }

    private static interface EntityChecker {
        public void checkValue(CharSequence var1, Location var2) throws XPathException;
    }
}

