/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.index;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.ids_mannheim.korap.response.MetaField;
import de.ids_mannheim.korap.response.MetaFieldsObj;
import de.ids_mannheim.korap.response.Response;
import de.ids_mannheim.korap.util.KrillDate;
import de.ids_mannheim.korap.util.KrillString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class AbstractDocument
extends Response {
    ObjectMapper mapper = new ObjectMapper();
    private String primaryData;
    private static HashSet<String> legacyStringFields = new HashSet<String>(Arrays.asList("pubPlace", "textSigle", "docSigle", "corpusSigle", "textType", "textTypeArt", "textTypeRef", "textColumn", "textDomain", "availability", "language", "corpusID", "ID"));
    private static HashSet<String> legacyTextFields = new HashSet<String>(Arrays.asList("author", "title", "subTitle", "corpusTitle", "corpusSubTitle", "corpusAuthor", "docTitle", "docSubTitle", "docAuthor"));
    private static HashSet<String> legacyKeywordsFields = new HashSet<String>(Arrays.asList("textClass", "foundries", "keywords"));
    private static HashSet<String> legacyStoredFields = new HashSet<String>(Arrays.asList("docEditor", "tokenSource", "layerInfos", "publisher", "editor", "fileEditionStatement", "biblEditionStatement", "reference", "corpusEditor"));
    private static HashSet<String> legacyDateFields = new HashSet<String>(Arrays.asList("pubDate", "creationDate"));
    @JsonIgnore
    public int internalDocID;
    @JsonIgnore
    public int localDocID;
    @JsonIgnore
    public int UID;
    @JsonIgnore
    public MetaFieldsObj mFields = new MetaFieldsObj();

    public void populateDocument(Document doc, String field) {
        ArrayList<String> fieldList = new ArrayList<String>(32);
        Iterator<IndexableField> fieldIterator = doc.getFields().iterator();
        while (fieldIterator.hasNext()) {
            fieldList.add(fieldIterator.next().name());
        }
        this.populateDocument(doc, field, fieldList);
    }

    public void populateDocument(Document doc, String field, List<String> fields) {
        if (field != null) {
            this.setPrimaryData(doc.get(field));
        }
        this.populateFields(doc, fields);
    }

    public void populateFields(Document doc) {
        ArrayList<String> fieldList = new ArrayList<String>(32);
        Iterator<IndexableField> fieldIterator = doc.getFields().iterator();
        while (fieldIterator.hasNext()) {
            fieldList.add(fieldIterator.next().name());
        }
        this.populateFields(doc, fieldList);
    }

    public void populateFields(Document doc, List<String> fields) {
        Iterator<String> fieldsIter = fields.iterator();
        if (fields.contains("UID")) {
            this.setUID(doc.get("UID"));
        }
        this.mFields.fieldsOrder = new ArrayList<String>(16);
        while (fieldsIter.hasNext()) {
            IndexableField iField;
            String name = fieldsIter.next();
            if (name.equals("tokens") || name.equals("UID")) continue;
            this.mFields.fieldsOrder.add(name);
            if (this.mFields.contains(name).booleanValue() || (iField = doc.getField(name)) == null) continue;
            MetaField mf = this.mFields.add(iField);
            if (!name.equals("license")) continue;
            this.addString("availability", doc.get("license"));
        }
    }

    @JsonProperty(value="UID")
    public int getUID() {
        return this.UID;
    }

    public void setUID(int UID) {
        if (UID != 0) {
            this.UID = UID;
            this.addString("UID", Integer.valueOf(UID).toString());
        }
    }

    public void setUID(String UID) throws NumberFormatException {
        if (UID != null) {
            this.UID = Integer.parseInt(UID);
            this.addString("UID", Integer.valueOf(this.UID).toString());
        }
    }

    @JsonIgnore
    public String getPrimaryData() {
        if (this.primaryData == null) {
            return "";
        }
        return this.primaryData;
    }

    @JsonIgnore
    public String getPrimaryData(int startOffset) {
        return KrillString.codePointSubstring(this.primaryData, startOffset);
    }

    @JsonIgnore
    public String getPrimaryData(int startOffset, int endOffset) {
        return KrillString.codePointSubstring(this.primaryData, startOffset, endOffset);
    }

    public void setPrimaryData(String primary) {
        this.primaryData = primary;
    }

    @JsonIgnore
    public int getPrimaryDataLength() {
        return this.primaryData.length();
    }

    @JsonIgnore
    public String getTextSigle() {
        return this.getFieldValue("textSigle");
    }

    @JsonIgnore
    public String getDocSigle() {
        return this.getFieldValue("docSigle");
    }

    @JsonIgnore
    public String getCorpusSigle() {
        return this.getFieldValue("corpusSigle");
    }

    @Deprecated
    @JsonIgnore
    public String getAvailability() {
        return this.getFieldValue("availability");
    }

    @Deprecated
    @JsonProperty(value="corpusID")
    public String getCorpusID() {
        return this.getFieldValue("corpusID");
    }

    @Deprecated
    @JsonProperty(value="ID")
    public String getID() {
        return this.getFieldValue("ID");
    }

    @JsonAnyGetter
    public Map<String, JsonNode> getLegacyMetaFields() {
        Iterator<MetaField> mfIterator = this.mFields.iterator();
        HashMap<String, JsonNode> map = new HashMap<String, JsonNode>();
        while (mfIterator.hasNext()) {
            String mfs;
            String value;
            MetaField mf = mfIterator.next();
            if (mf == null || (value = this.getFieldValue(mfs = mf.key)) == null || !legacyDateFields.contains(mfs) && !legacyStoredFields.contains(mfs) && !legacyTextFields.contains(mfs) && !legacyStringFields.contains(mfs) && !legacyKeywordsFields.contains(mfs) && !legacyDateFields.contains(mfs)) continue;
            map.put(mfs, new TextNode(value));
        }
        return map;
    }

    @JsonAnySetter
    public void setLegacyMetaField(String name, JsonNode value) {
        if (legacyStringFields.contains(name)) {
            this.addString(name, value.asText());
        } else if (legacyTextFields.contains(name)) {
            this.addText(name, value.asText());
        } else if (legacyKeywordsFields.contains(name)) {
            this.addKeywords(name, value.asText());
        } else if (legacyStoredFields.contains(name)) {
            this.addStored(name, value.asText());
        } else if (legacyDateFields.contains(name)) {
            this.addDate(name, value.asText());
        } else if (name.equals("license")) {
            this.addString("availability", value.asText());
        } else if (name.equals("store")) {
            // empty if block
        }
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectNode json = (ObjectNode)super.toJsonNode();
        json.setAll((ObjectNode)this.mapper.valueToTree(this));
        if (this.getUID() == 0) {
            json.remove("UID");
        }
        return json;
    }

    @JsonIgnore
    public String getFieldValue(String field) {
        MetaField mf = this.mFields.get(field);
        if (mf != null && mf.values.size() > 0) {
            return String.join((CharSequence)" ", mf.values);
        }
        return null;
    }

    @JsonIgnore
    public KrillDate getFieldValueAsDate(String field) {
        String date = this.getFieldValue(field);
        if (date == null) {
            return null;
        }
        return new KrillDate(date);
    }

    @JsonIgnore
    public void addString(String key, String value) {
        if (value == null) {
            return;
        }
        this.mFields.add(new MetaField(key, "type:string", value));
    }

    @JsonIgnore
    public void addInt(String key, String value) {
        if (value == null) {
            return;
        }
        this.mFields.add(new MetaField(key, "type:integer", value));
    }

    @JsonIgnore
    public void addInt(String key, int value) {
        this.addInt(key, Integer.valueOf(value).toString());
    }

    @JsonIgnore
    public void addStored(String key, String value) {
        if (value == null) {
            return;
        }
        this.mFields.add(new MetaField(key, "type:store", value));
    }

    @JsonIgnore
    public void addAttachement(String key, String value) {
        if (value == null) {
            return;
        }
        this.mFields.add(new MetaField(key, "type:attachement", value));
    }

    @JsonIgnore
    public void addKeywords(String key, String value) {
        if (value == null) {
            return;
        }
        this.mFields.add(new MetaField(key, "type:keywords", value));
    }

    @JsonIgnore
    public void addText(String key, String value) {
        if (value == null) {
            return;
        }
        this.mFields.add(new MetaField(key, "type:text", value));
    }

    @JsonIgnore
    public void addDate(String key, String value) {
        if (value == null) {
            return;
        }
        KrillDate date = new KrillDate(value);
        if (date == null) {
            return;
        }
        this.mFields.add(new MetaField(key, "type:date", date.toDisplay()));
    }

    @JsonIgnore
    public void addDate(String key, int value) {
        this.addDate(key, Integer.valueOf(value).toString());
    }
}

