/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class While
extends Instruction {
    private final Operand conditionOp;
    private final Operand actionOp;

    public While(Expression test, Expression action) {
        this.conditionOp = new Operand(this, test, OperandRole.INSPECT);
        this.actionOp = new Operand(this, action, OperandRole.FOCUS_CONTROLLED_ACTION);
    }

    public Expression getTest() {
        return this.conditionOp.getChildExpression();
    }

    public void setTest(Expression test) {
        this.conditionOp.setChildExpression(test);
    }

    public Expression getAction() {
        return this.actionOp.getChildExpression();
    }

    public void setAction(Expression action) {
        this.actionOp.setChildExpression(action);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.conditionOp, this.actionOp);
    }

    @Override
    public int getInstructionNameCode() {
        return 271;
    }

    public Expression getActionExpression() {
        return this.getAction();
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        While exp = new While(this.getTest().copy(rebindings), this.getAction().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public ItemType getItemType() {
        return this.getAction().getItemType();
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return !this.getAction().hasSpecialProperty(0x800000);
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("while", this);
        this.getTest().export(out);
        this.getAction().export(out);
        out.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new WhileElaborator();
    }

    public static class WhileElaborator
    extends PushElaborator {
        @Override
        public PushEvaluator elaborateForPush() {
            While expr = (While)this.getExpression();
            BooleanEvaluator test = expr.getTest().makeElaborator().elaborateForBoolean();
            PushEvaluator action = expr.getAction().makeElaborator().elaborateForPush();
            return (output, context) -> {
                while (test.eval(context)) {
                    Expression.dispatchTailCall(action.processLeavingTail(output, context));
                }
                return null;
            };
        }
    }
}

