/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.ids_mannheim.korap.KrillCollection;
import de.ids_mannheim.korap.KrillMeta;
import de.ids_mannheim.korap.KrillQuery;
import de.ids_mannheim.korap.KrillStats;
import de.ids_mannheim.korap.response.Notifications;
import de.ids_mannheim.korap.util.KrillString;
import java.util.HashMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Response
extends Notifications {
    ObjectMapper mapper = new ObjectMapper();
    private KrillMeta meta;
    private KrillCollection collection;
    private KrillQuery query;
    private KrillStats stats;
    private String version;
    private String name;
    private String node;
    private String listener;
    private long totalResources = -2L;
    private long totalResults = -2L;
    private String benchmark;
    private boolean timeExceeded = false;
    private HashMap<String, ObjectNode> jsonFields;
    public static final String KORAL_VERSION = "http://korap.ids-mannheim.de/ns/KoralQuery/v0.3/context.jsonld";

    @JsonIgnore
    public String getVersion() {
        return this.version;
    }

    public Response setVersion(String fullVersion) {
        int found = fullVersion.lastIndexOf(45);
        if (found > 0 && found + 1 < fullVersion.length()) {
            this.setName(fullVersion.substring(0, found));
            this.version = fullVersion.substring(found + 1);
        } else {
            this.version = fullVersion;
        }
        return this;
    }

    @JsonIgnore
    public String getName() {
        return this.name;
    }

    public Response setName(String name) {
        this.name = name;
        return this;
    }

    @JsonIgnore
    public String getNode() {
        return this.node;
    }

    public Response setNode(String name) {
        this.node = name;
        return this;
    }

    @JsonIgnore
    public boolean hasTimeExceeded() {
        return this.timeExceeded;
    }

    public Response setTimeExceeded(boolean timeout) {
        if (timeout) {
            this.addWarning(682, "Response time exceeded", new String[0]);
        }
        this.timeExceeded = timeout;
        return this;
    }

    @JsonIgnore
    public String getBenchmark() {
        return this.benchmark;
    }

    @JsonIgnore
    public Response setBenchmark(long ts1, long ts2) {
        this.benchmark = ts2 - ts1 < 100000000L ? (double)(ts2 - ts1) * 1.0E-6 + " ms" : (double)(ts2 - ts1) / 1.0E9 + " s";
        return this;
    }

    public Response setBenchmark(String bm) {
        this.benchmark = bm;
        return this;
    }

    @JsonIgnore
    public String getListener() {
        return this.listener;
    }

    public Response setListener(String listener) {
        this.listener = listener;
        return this;
    }

    @JsonIgnore
    public long getTotalResults() {
        if (this.totalResults == -2L) {
            return 0L;
        }
        return this.totalResults;
    }

    public Response setTotalResults(long results) {
        this.totalResults = results;
        return this;
    }

    public Response incrTotalResults(int incr) {
        this.totalResults = this.totalResults < 0L ? (long)incr : (this.totalResults += (long)incr);
        return this;
    }

    @JsonIgnore
    public long getTotalResources() {
        if (this.totalResources == -2L) {
            return 0L;
        }
        return this.totalResources;
    }

    public Response setTotalResources(long resources) {
        this.totalResources = resources;
        return this;
    }

    public Response incrTotalResources(int i) {
        this.totalResources = this.totalResources < 0L ? (long)i : (this.totalResources += (long)i);
        return this;
    }

    @JsonIgnore
    public KrillQuery getQuery() {
        if (this.query == null) {
            this.query = new KrillQuery("tokens");
        }
        return this.query;
    }

    @JsonIgnore
    public Response setQuery(KrillQuery query) {
        this.query = query;
        return (Response)this.moveNotificationsFrom(query);
    }

    @JsonIgnore
    public KrillCollection getCollection() {
        if (this.collection == null) {
            this.collection = new KrillCollection();
        }
        return this.collection;
    }

    @JsonIgnore
    public Response setCollection(KrillCollection collection) {
        this.collection = collection;
        Response resp = (Response)this.moveNotificationsFrom(collection);
        return resp;
    }

    @JsonIgnore
    public KrillMeta getMeta() {
        if (this.meta == null) {
            this.meta = new KrillMeta();
        }
        return this.meta;
    }

    @JsonIgnore
    public Response setMeta(KrillMeta meta) {
        this.meta = meta;
        return (Response)this.moveNotificationsFrom(meta);
    }

    @JsonIgnore
    public KrillStats getStats() {
        if (this.stats == null) {
            this.stats = new KrillStats();
        }
        return this.stats;
    }

    @JsonIgnore
    public Response setStats(KrillStats stats) {
        this.stats = stats;
        return (Response)this.moveNotificationsFrom(stats);
    }

    public void addJsonNode(String key, ObjectNode value) {
        if (this.jsonFields == null) {
            this.jsonFields = new HashMap(4);
        }
        this.jsonFields.put(key, value);
    }

    @Override
    public JsonNode toJsonNode() {
        JsonNode collNode;
        JsonNode queryNode;
        ObjectNode meta;
        JsonNode metaNode;
        ObjectNode json = (ObjectNode)super.toJsonNode();
        json.put("@context", KORAL_VERSION);
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null) {
            sb.append(this.getName());
            if (this.getVersion() != null) {
                sb.append("-");
            }
        }
        if (this.getVersion() != null) {
            sb.append(this.getVersion());
        }
        if (this.meta != null && (metaNode = this.meta.toJsonNode()) != null) {
            json.set("meta", metaNode);
        }
        ObjectNode objectNode = meta = json.has("meta") ? (ObjectNode)json.get("meta") : json.putObject("meta");
        if (sb.length() > 0) {
            meta.put("version", sb.toString());
        }
        if (this.timeExceeded) {
            meta.put("timeExceeded", true);
        }
        if (this.getNode() != null) {
            meta.put("node", this.getNode());
        }
        if (this.getListener() != null) {
            meta.put("listener", this.getListener());
        }
        if (this.getBenchmark() != null) {
            meta.put("benchmark", this.getBenchmark());
        }
        if (this.totalResources != -2L) {
            meta.put("totalResources", this.totalResources);
        }
        if (this.totalResults != -2L) {
            meta.put("totalResults", this.totalResults);
        }
        if (this.jsonFields != null) {
            json.setAll(this.jsonFields);
        }
        if (this.query != null && (queryNode = this.getQuery().toJsonNode()) != null) {
            json.set("query", queryNode);
        }
        if (this.collection != null && (collNode = this.collection.toJsonNode()) != null) {
            json.set("corpus", collNode);
            json.set("collection", collNode);
        }
        return json;
    }

    @Override
    public String toJsonString() {
        Object msg = "";
        try {
            return this.mapper.writeValueAsString(this.toJsonNode());
        }
        catch (Exception e) {
            msg = ", " + KrillString.quote(e.getLocalizedMessage());
            return "{\"errors\":[[620, \"Unable to generate JSON\"" + (String)msg + "]]}";
        }
    }
}

