/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2.httpserver;

import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.net.ssl.SSLContext;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.JerseySeBootstrapConfiguration;
import org.glassfish.jersey.server.spi.WebServer;

final class GrizzlyHttpServer
implements WebServer {
    private final GrizzlyHttpContainer container;
    private final HttpServer httpServer;

    GrizzlyHttpServer(Application application, JerseySeBootstrapConfiguration configuration) {
        this(new GrizzlyHttpContainer(application), configuration);
    }

    GrizzlyHttpServer(Class<? extends Application> applicationClass, JerseySeBootstrapConfiguration configuration) {
        this(new GrizzlyHttpContainer(applicationClass), configuration);
    }

    private GrizzlyHttpServer(GrizzlyHttpContainer container, JerseySeBootstrapConfiguration configuration) {
        SSLContext sslContext = configuration.sslContext();
        SeBootstrap.Configuration.SSLClientAuthentication sslClientAuthentication = configuration.sslClientAuthentication();
        this.container = container;
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer(configuration.uri(true), this.container, configuration.isHttps(), configuration.isHttps() ? new SSLEngineConfigurator(sslContext, false, sslClientAuthentication == SeBootstrap.Configuration.SSLClientAuthentication.MANDATORY, sslClientAuthentication == SeBootstrap.Configuration.SSLClientAuthentication.OPTIONAL) : null, configuration.autoStart());
    }

    @Override
    public final GrizzlyHttpContainer container() {
        return this.container;
    }

    @Override
    public final int port() {
        return this.httpServer.getListener("grizzly").getPort();
    }

    public final CompletableFuture<Void> start() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.httpServer.start();
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public final CompletableFuture<Void> stop() {
        return CompletableFuture.runAsync(this.httpServer::shutdownNow);
    }

    @Override
    public final <T> T unwrap(Class<T> nativeClass) {
        return nativeClass.cast(this.httpServer);
    }
}

