/*
 * Decompiled with CFR 0.152.
 */
package lemming.test.lemma.ranker;

import java.util.List;
import lemming.lemma.LemmaInstance;
import lemming.lemma.LemmaResult;
import lemming.lemma.Lemmatizer;
import lemming.lemma.ranker.RankerTrainer;
import lemming.test.lemma.toutanova.SimpleTrainerTest;
import marmot.test.morph.PipelineTest;
import org.junit.Test;

public class RankerTrainerTest
extends SimpleTrainerTest {
    @Test
    public void isSerializable() {
        this.testIfLemmatizerIsSerializable(new RankerTrainer());
    }

    @Test
    public void smallTest() {
        RankerTrainer trainer = new RankerTrainer();
        trainer.getOptions().setOption("use-perceptron", false).setOption("quadratic-penalty", 1.0);
        trainer.getOptions().setOption("use-shape-lexicon", true);
        trainer.getOptions().setOption("num-edit-tree-steps", 0);
        trainer.getOptions().setOption("use-morph", false);
        trainer.getOptions().setOption("use-hash-feature-table", true);
        this.runModerateTest(trainer, 1.0, 1.0, true);
    }

    @Test
    public void smallNoMorphMarmotTest() {
        String trainfile = "form-index=1,lemma-index=2,res:///marmot/test/morph/trn.txt";
        String devfile = "form-index=1,lemma-index=2,res:///marmot/test/morph/tst.txt";
        List<LemmaInstance> instances = LemmaInstance.getInstances(PipelineTest.getSentences(trainfile, 100));
        System.err.println(instances.size());
        RankerTrainer trainer = new RankerTrainer();
        trainer.getOptions().setOption("use-perceptron", false).setOption("quadratic-penalty", 0.0);
        trainer.getOptions().setOption("use-morph", false);
        trainer.getOptions().setOption("use-pos", false);
        Lemmatizer lemmatizer = trainer.train((List)instances, (List)null);
        instances = LemmaInstance.getInstances(PipelineTest.getSentences(devfile, 100));
        LemmaResult result = LemmaResult.test(lemmatizer, instances);
        result.logAccuracy();
    }

    @Test
    public void smallMarmotTest() {
        RankerTrainer trainer = new RankerTrainer();
        String trainfile = "form-index=1,lemma-index=2,tag-index=4,morph-index=6,res:///marmot/test/morph/trn.txt";
        String devfile = "form-index=1,lemma-index=2,tag-index=4,morph-index=6,res:///marmot/test/morph/tst.txt";
        trainer.getOptions().setOption("use-perceptron", false).setOption("quadratic-penalty", 0.0);
        trainer.getOptions().setOption("use-morph", true);
        List<LemmaInstance> instances = LemmaInstance.getInstances(PipelineTest.getSentences(trainfile, 100));
        Lemmatizer lemmatizer = trainer.train((List)instances, (List)null);
        instances = LemmaInstance.getInstances(PipelineTest.getSentences(devfile, 100));
        LemmaResult result = LemmaResult.test(lemmatizer, instances);
        result.logAccuracy();
        assert (result.getTokenAccuracy() > 97.94);
    }
}

