/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.spans.FocusSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class SpanFocusQuery
extends SimpleSpanQuery {
    private List<Byte> classNumbers = new ArrayList<Byte>();
    private boolean isSorted = true;
    private boolean matchTemporaryClass = false;
    private boolean removeTemporaryClasses = false;
    private int windowSize = 10;

    public SpanFocusQuery(SpanQuery sq, byte classNumber) {
        super(sq, true);
        this.classNumbers.add(classNumber);
    }

    public SpanFocusQuery(SpanQuery sq, List<Byte> classNumbers) {
        super(sq, true);
        this.classNumbers = classNumbers;
    }

    public SpanFocusQuery(SpanQuery sq) {
        super(sq, true);
        this.classNumbers.add((byte)1);
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("focus(");
        if (this.matchTemporaryClass) {
            buffer.append("#");
        }
        if (this.classNumbers.size() > 1) {
            buffer.append("[");
            for (int i = 0; i < this.classNumbers.size(); ++i) {
                buffer.append((short)this.classNumbers.get(i).byteValue() & 0xFF);
                if (i == this.classNumbers.size() - 1) continue;
                buffer.append(",");
            }
            buffer.append("]");
        } else {
            buffer.append((short)this.classNumbers.get(0).byteValue() & 0xFF).append(": ");
        }
        buffer.append(this.firstClause.toString());
        if (!this.isSorted()) {
            buffer.append(",sorting");
        }
        buffer.append(')');
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        return new FocusSpans(this, context, acceptDocs, termContexts);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        SpanFocusQuery clone = null;
        SpanQuery query = (SpanQuery)this.firstClause.rewrite(reader);
        if (query != this.firstClause) {
            if (clone == null) {
                clone = this.clone();
            }
            clone.firstClause = query;
        }
        if (clone != null) {
            return clone;
        }
        return this;
    }

    @Override
    public SpanFocusQuery clone() {
        SpanFocusQuery spanFocusQuery = new SpanFocusQuery((SpanQuery)this.firstClause.clone(), this.getClassNumbers());
        spanFocusQuery.setBoost(this.getBoost());
        spanFocusQuery.setMatchTemporaryClass(this.matchTemporaryClass);
        spanFocusQuery.setSorted(this.isSorted);
        spanFocusQuery.setRemoveTemporaryClasses(this.removeTemporaryClasses);
        return spanFocusQuery;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanFocusQuery)) {
            return false;
        }
        SpanFocusQuery spanFocusQuery = (SpanFocusQuery)o;
        if (!this.firstClause.equals(spanFocusQuery.firstClause)) {
            return false;
        }
        if (this.getClassNumbers() != spanFocusQuery.getClassNumbers()) {
            return false;
        }
        return this.getBoost() == spanFocusQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int result = this.firstClause.hashCode();
        for (byte number : this.classNumbers) {
            result = 31 * result + number;
        }
        return result += Float.floatToRawIntBits(this.getBoost());
    }

    public List<Byte> getClassNumbers() {
        return this.classNumbers;
    }

    public void setClassNumbers(List<Byte> classNumbers) {
        this.classNumbers = classNumbers;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public void setSorted(boolean isSorted) {
        this.isSorted = isSorted;
    }

    public boolean matchTemporaryClass() {
        return this.matchTemporaryClass;
    }

    public void setMatchTemporaryClass(boolean matchTemporaryClass) {
        this.matchTemporaryClass = matchTemporaryClass;
    }

    public boolean removeTemporaryClasses() {
        return this.removeTemporaryClasses;
    }

    public void setRemoveTemporaryClasses(boolean rem) {
        this.removeTemporaryClasses = rem;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }
}

