/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.analyzer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import marmot.morph.analyzer.Analyzer;
import marmot.thirdparty.aramorph.AraMorph;
import marmot.thirdparty.aramorph.Solution;

public class ArabicAnalyzer
extends Analyzer {
    private static final long serialVersionUID = 1L;
    private transient AraMorph aramorph_ = null;
    private boolean subfeatures_;

    public ArabicAnalyzer(boolean subfeatures) {
        this.subfeatures_ = subfeatures;
    }

    @Override
    public List<String> analyze(String form) {
        Set<Solution> solutions;
        if (this.aramorph_ == null) {
            this.aramorph_ = new AraMorph();
        }
        if ((solutions = this.aramorph_.analyzeToken(form)) == null || solutions.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        HashSet<String> set = new HashSet<String>();
        for (Solution solution : solutions) {
            sb.setLength(0);
            List<String> feats = solution.getFeatures();
            for (String feat : feats) {
                if (feat.isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append('|');
                }
                sb.append(feat);
                if (!this.subfeatures_) continue;
                set.add(feat);
                String[] parts = feat.split("_:");
                if (parts.length <= 1) continue;
                for (String part : parts) {
                    if (part.isEmpty()) continue;
                    set.add(part);
                }
            }
            set.add(sb.toString());
        }
        if (set.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(set);
    }
}

