/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.converter.AnyTypeToStringConverterCompiler;
import com.saxonica.ee.bytecode.converter.BooleanToDoubleCompiler;
import com.saxonica.ee.bytecode.converter.BooleanToFloatCompiler;
import com.saxonica.ee.bytecode.converter.BooleanToIntegerCompiler;
import com.saxonica.ee.bytecode.converter.BooleanToStringCompiler;
import com.saxonica.ee.bytecode.converter.BooleanToUntypedAtomicCompiler;
import com.saxonica.ee.bytecode.converter.ConverterCompiler;
import com.saxonica.ee.bytecode.converter.DoubleToBooleanCompiler;
import com.saxonica.ee.bytecode.converter.DoubleToFloatCompiler;
import com.saxonica.ee.bytecode.converter.DoubleToIntegerCompiler;
import com.saxonica.ee.bytecode.converter.DoubleToStringCompiler;
import com.saxonica.ee.bytecode.converter.DoubleToUntypedAtomicCompiler;
import com.saxonica.ee.bytecode.converter.FloatToBooleanCompiler;
import com.saxonica.ee.bytecode.converter.FloatToDoubleCompiler;
import com.saxonica.ee.bytecode.converter.FloatToIntegerCompiler;
import com.saxonica.ee.bytecode.converter.FloatToStringCompiler;
import com.saxonica.ee.bytecode.converter.FloatToUntypedAtomicCompiler;
import com.saxonica.ee.bytecode.converter.IntegerToBooleanCompiler;
import com.saxonica.ee.bytecode.converter.IntegerToDoubleCompiler;
import com.saxonica.ee.bytecode.converter.IntegerToFloatCompiler;
import com.saxonica.ee.bytecode.converter.IntegerToStringCompiler;
import com.saxonica.ee.bytecode.converter.IntegerToUntypedAtomicCompiler;
import com.saxonica.ee.bytecode.converter.StringToBooleanCompiler;
import com.saxonica.ee.bytecode.converter.StringToDoubleCompiler;
import com.saxonica.ee.bytecode.converter.StringToFloatCompiler;
import com.saxonica.ee.bytecode.converter.StringToIntegerCompiler;
import com.saxonica.ee.bytecode.converter.StringToUntypedAtomicCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.TypeHierarchy;

public class CastExpressionCompiler
extends ToItemCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression base = ((CastExpression)expression).getBaseExpression();
        AtomicType targetType = ((CastExpression)expression).getTargetType();
        CastExpressionCompiler.visitAnnotation(compiler, "CastExpression-Item");
        PlainType sourceType = (PlainType)base.getItemType();
        ConverterCompiler converterCompiler = CastExpressionCompiler.getConverterCompiler(sourceType, targetType);
        converterCompiler.compileToItem(compiler, expression);
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        AtomicType targetType = cast.getTargetType();
        Converter converter = cast.getConverter();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        PlainType sourceType = (PlainType)base.getItemType();
        CastExpressionCompiler.visitAnnotation(compiler, "CastExpression-Primitive");
        ConverterCompiler converterCompiler = CastExpressionCompiler.getConverterCompiler(sourceType, targetType);
        if (converterCompiler instanceof ConverterCompiler.GenericConverterCompiler) {
            super.compileToPrimitive(compiler, expression, requiredClass, onEmpty);
        } else {
            converterCompiler.compileToPrimitive(compiler, expression, requiredClass, onEmpty);
        }
    }

    public static ConverterCompiler getConverterCompiler(PlainType sourceType, AtomicType targetType) throws CannotCompileException {
        if (sourceType.isAtomicType()) {
            int tt = targetType.getFingerprint();
            int st = sourceType.getPrimitiveType();
            switch (tt) {
                case 631: {
                    switch (st) {
                        case 513: {
                            return new StringToUntypedAtomicCompiler();
                        }
                        case 517: {
                            return new DoubleToUntypedAtomicCompiler();
                        }
                        case 516: {
                            return new FloatToUntypedAtomicCompiler();
                        }
                        case 533: {
                            return new IntegerToUntypedAtomicCompiler();
                        }
                        case 514: {
                            return new BooleanToUntypedAtomicCompiler();
                        }
                    }
                    return new ConverterCompiler.GenericConverterCompiler();
                }
                case 513: {
                    switch (st) {
                        case 517: {
                            return new DoubleToStringCompiler();
                        }
                        case 516: {
                            return new FloatToStringCompiler();
                        }
                        case 533: {
                            return new IntegerToStringCompiler();
                        }
                        case 514: {
                            return new BooleanToStringCompiler();
                        }
                    }
                    return new AnyTypeToStringConverterCompiler();
                }
                case 516: {
                    switch (st) {
                        case 513: 
                        case 631: {
                            return new StringToFloatCompiler();
                        }
                        case 517: {
                            return new DoubleToFloatCompiler();
                        }
                        case 533: {
                            return new IntegerToFloatCompiler();
                        }
                        case 514: {
                            return new BooleanToFloatCompiler();
                        }
                    }
                    return new ConverterCompiler.GenericConverterCompiler();
                }
                case 517: {
                    switch (st) {
                        case 513: 
                        case 631: {
                            return new StringToDoubleCompiler();
                        }
                        case 516: {
                            return new FloatToDoubleCompiler();
                        }
                        case 533: {
                            return new IntegerToDoubleCompiler();
                        }
                        case 514: {
                            return new BooleanToDoubleCompiler();
                        }
                    }
                    return new ConverterCompiler.GenericConverterCompiler();
                }
                case 533: {
                    switch (st) {
                        case 513: 
                        case 631: {
                            return new StringToIntegerCompiler();
                        }
                        case 516: {
                            return new FloatToIntegerCompiler();
                        }
                        case 517: {
                            return new DoubleToIntegerCompiler();
                        }
                        case 514: {
                            return new BooleanToIntegerCompiler();
                        }
                    }
                    return new ConverterCompiler.GenericConverterCompiler();
                }
                case 514: {
                    switch (st) {
                        case 513: 
                        case 631: {
                            return new StringToBooleanCompiler();
                        }
                        case 516: {
                            return new FloatToBooleanCompiler();
                        }
                        case 517: {
                            return new DoubleToBooleanCompiler();
                        }
                        case 533: {
                            return new IntegerToBooleanCompiler();
                        }
                    }
                    return new ConverterCompiler.GenericConverterCompiler();
                }
            }
            return new ConverterCompiler.GenericConverterCompiler();
        }
        return new ConverterCompiler.GenericConverterCompiler();
    }
}

