/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.fsa;

import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.IdentityConstraintReference;
import com.saxonica.ee.schema.Key;
import com.saxonica.ee.schema.KeyRef;
import com.saxonica.ee.schema.ModelGroupParticle;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.Unique;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.fsa.AutomatonState;
import com.saxonica.ee.schema.fsa.CountingState;
import com.saxonica.ee.schema.fsa.State;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;

public class Edge {
    private Term term;
    private Particle particle;
    private AutomatonState targetState;
    public static final MaxOccursParticle MAX_OCCURS_PARTICLE = new MaxOccursParticle();

    public void setTargetState(AutomatonState targetState) {
        this.targetState = targetState;
    }

    public AutomatonState getTargetState() {
        return this.targetState;
    }

    public State makeTransition(State previousState) throws ValidationException {
        if (previousState instanceof CountingState) {
            if (((CountingState)previousState).getUnderlyingState() == this.targetState) {
                return ((CountingState)previousState).incrementCounter();
            }
            ((CountingState)previousState).testMinimumReached();
        }
        if (this.targetState.requiresCounter()) {
            return new CountingState(this.targetState, 1);
        }
        return this.targetState;
    }

    public void setTerm(Term term) {
        this.term = term;
    }

    public Term getTerm() {
        return this.term;
    }

    public void setParticle(Particle particle) {
        this.particle = particle;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public String matches(Edge de, SchemaCompiler compiler) throws MissingComponentException {
        if (this.term == de.term) {
            return null;
        }
        if (this.term instanceof ElementDecl && de.term instanceof ElementDecl && ((ElementDecl)this.term).getFingerprint() == ((ElementDecl)de.term).getFingerprint()) {
            IdentityConstraint ic;
            ElementDecl base = (ElementDecl)this.term;
            ElementDecl sub = (ElementDecl)de.term;
            SchemaType baseType = base.getType();
            SchemaType subType = sub.getType();
            if (sub.isNillable() && !base.isNillable()) {
                return "The element in the derived type is nillable but the corresponding element in the base type is not";
            }
            if (base.getFixedValue() != null) {
                if (sub.getFixedValue() == null) {
                    return "The element in the base type has a fixed value, but the corresponding element in derived type does not";
                }
                if (!sub.getFixedValue().getSchemaComparable().equals(base.getFixedValue().getSchemaComparable())) {
                    return "The element in the derived type has a different fixed value from the corresponding element in the base type";
                }
            }
            boolean elementTypeOK = true;
            String reason = null;
            if (subType.isSimpleType()) {
                reason = UserSimpleType.isTypeDerivationOK((SimpleType)subType, baseType, 0);
                elementTypeOK = reason == null;
            } else {
                while (!baseType.isSameType(subType)) {
                    if (subType.getDerivationMethod() != 1) {
                        elementTypeOK = false;
                        break;
                    }
                    if ((subType = subType.getBaseType()) != null) continue;
                    elementTypeOK = false;
                    break;
                }
            }
            if (!elementTypeOK) {
                return "The type of the element in the restricted content model is not validly derived from the type of the corresponding element in the base content model" + (reason == null ? "" : ". " + reason);
            }
            if (base.getFixedValue() != null && !base.getFixedValue().getSchemaComparable().equals(sub.getFixedValue().getSchemaComparable())) {
                return "The fixed value of the element in the base content model is not reflected in the corresponding element of the restricted content model";
            }
            int baseUniqueCount = 0;
            int baseKeyCount = 0;
            int baseKeyRefCount = 0;
            int derivedUniqueCount = 0;
            int derivedKeyCount = 0;
            int derivedKeyRefCount = 0;
            for (IdentityConstraintReference icr : base.getIdentityConstraints()) {
                ic = icr.getTarget();
                if (ic instanceof Unique) {
                    ++baseUniqueCount;
                    continue;
                }
                if (ic instanceof Key) {
                    ++baseKeyCount;
                    continue;
                }
                if (!(ic instanceof KeyRef)) continue;
                ++baseKeyRefCount;
            }
            for (IdentityConstraintReference icr : sub.getIdentityConstraints()) {
                ic = icr.getTarget();
                if (ic instanceof Unique) {
                    ++derivedUniqueCount;
                    continue;
                }
                if (ic instanceof Key) {
                    ++derivedKeyCount;
                    continue;
                }
                if (!(ic instanceof KeyRef)) continue;
                ++derivedKeyRefCount;
            }
            if (baseUniqueCount > derivedUniqueCount) {
                return "Element in base content model has a uniqueness constraint that is not present in the corresponding element of the restricted content model";
            }
            if (baseKeyCount > derivedKeyCount) {
                return "Element in base content model has a key constraint that is not present in the corresponding element of the restricted content model";
            }
            if (baseKeyRefCount > derivedKeyRefCount) {
                return "Element in base content model has a keyref constraint that is not present in the corresponding element of the restricted content model";
            }
            if (baseUniqueCount > 0 || baseKeyCount > 0 || baseKeyRefCount > 0) {
                compiler.warning("Saxon is not able to verify that the identity constraints defined on element " + base.getDisplayName() + " are compatible between the base type and the derived type", sub);
            }
            if (de.getTargetState().isFinalState() && !this.getTargetState().isFinalState() && !this.getTargetState().isConditionallyFinalState()) {
                return "Not final";
            }
            if ((base.getBlock() & ~sub.getBlock()) != 0) {
                return "The disallowed substitutions of the element in the restricted content model (@block) must be a superset of those in the base content model";
            }
            if (!base.hasSameTypeTable(sub)) {
                return "The type table of the element in the restricted content model must be the same as the type table of the element in the base content model";
            }
            return null;
        }
        if (this.term instanceof Wildcard && de.term instanceof ElementDecl && ((Wildcard)this.term).matches(((ElementDecl)de.term).getTargetNamespace())) {
            String mode = ((Wildcard)this.term).getProcessContents();
            PreparedSchema schema = compiler.getPreparedSchema();
            if (mode.equals("skip")) {
                return null;
            }
            if (mode.equals("strict")) {
                ElementDecl een = schema.getElementDecl(((ElementDecl)de.term).getComponentName());
                if (een == null) {
                    compiler.warning("There is no global element declaration named " + Err.wrap(((ElementDecl)de.term).getDisplayName()) + ", so the strict wildcard in the base type can never be satisfied", (ElementDecl)de.term);
                    return null;
                }
                SchemaType eent = een.getType();
                for (SchemaType et = ((ElementDecl)de.term).getType(); et != null; et = et.getBaseType()) {
                    if (et == eent) {
                        return null;
                    }
                    if (et.getDerivationMethod() != 1) break;
                }
                compiler.warning("The type of the local element declaration named " + Err.wrap(((ElementDecl)de.term).getDisplayName()) + " is not derived by restriction from that of the global element with the same name, so the strict wildcard in the base type can never be satisfied", (ElementDecl)de.term);
                return null;
            }
            if (mode.equals("lax")) {
                ElementDecl een = schema.getElementDecl(((ElementDecl)de.term).getComponentName());
                if (een == null) {
                    return null;
                }
                SchemaType eent = een.getType();
                for (SchemaType et = ((ElementDecl)de.term).getType(); et != null; et = et.getBaseType()) {
                    if (et == eent) {
                        return null;
                    }
                    if (et.getDerivationMethod() != 1) break;
                }
                compiler.warning("The type of the local element declaration named " + Err.wrap(((ElementDecl)de.term).getDisplayName()) + " is not derived by restriction from that of the global element with the same name, so the lax wildcard in the base type can never be satisfied", (ElementDecl)de.term);
                return null;
            }
            return null;
        }
        if (this.term instanceof Wildcard && de.term instanceof Wildcard) {
            if (!((Wildcard)de.term).isSubset((Wildcard)this.term, compiler.getNamePool())) {
                return "The xs:any wildcard in the restricted type allows namespaces that are not permitted by the wildcard in the base type";
            }
            if (((Wildcard)this.term).compareStrength((Wildcard)de.term) > 0) {
                return "The xs:any wildcard in the restricted type has a processContents that is less strict than the processContents in the base type";
            }
            return null;
        }
        return "No match";
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("edge");
        serializer.emitAttribute("term", serializer.getId((SchemaComponent)((Object)this.term), false));
        serializer.emitAttribute("to", this.targetState.getStateNumber() + "");
        serializer.endElement();
    }

    public static class MaxOccursParticle
    extends ModelGroupParticle {
        private static MaxOccursParticle THE_INSTANCE = new MaxOccursParticle();

        private MaxOccursParticle() {
            super(null, null);
        }

        public static MaxOccursParticle getInstance() {
            return THE_INSTANCE;
        }

        @Override
        public Term getTerm() {
            return MaxOccursTerm.getInstance();
        }
    }

    public static class MaxOccursTerm
    implements Term {
        private static MaxOccursTerm THE_INSTANCE = new MaxOccursTerm();

        private MaxOccursTerm() {
        }

        public static MaxOccursTerm getInstance() {
            return THE_INSTANCE;
        }
    }
}

