/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import java.util.Iterator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.SingleAtomicIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class CompactStringValue
implements AtomicSequence {
    char[] value;

    public CompactStringValue(String content) {
        this.value = content.toCharArray();
    }

    @Override
    public AtomicValue head() {
        return new StringValue(new String(this.value));
    }

    @Override
    public AtomicIterator iterate() {
        return new SingleAtomicIterator(this.head());
    }

    @Override
    public AtomicValue itemAt(int n) {
        return n == 0 ? this.head() : null;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public CharSequence getCanonicalLexicalRepresentation() {
        return this.head().getStringValueCS();
    }

    @Override
    public Comparable getSchemaComparable() {
        return new String(this.value);
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.head().getStringValueCS();
    }

    @Override
    public String getStringValue() {
        return this.head().getStringValue();
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        return this.head().subsequence(start, length);
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return this.value.length != 0;
    }

    @Override
    public GroundedValue reduce() {
        return this.head();
    }

    @Override
    public Iterator<AtomicValue> iterator() {
        return this.head().iterator();
    }

    public String toString() {
        return "\"" + new String(this.value) + '\"';
    }
}

