/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanElementQuery;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.TermSpans;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ElementSpans
extends SimpleSpans {
    private final TermSpans termSpans;
    private boolean isPayloadLoaded;
    private final Logger log = LoggerFactory.getLogger(ElementSpans.class);
    public static final boolean DEBUG = false;

    public ElementSpans(SpanElementQuery spanElementQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(spanElementQuery, context, acceptDocs, termContexts);
        this.termSpans = (TermSpans)this.firstSpans;
        this.hasMoreSpans = true;
    }

    @Override
    public boolean next() throws IOException {
        if (!this.hasMoreSpans || !(this.hasMoreSpans = this.termSpans.next())) {
            return false;
        }
        this.isStartEnumeration = false;
        this.matchPayload = null;
        this.matchEndPosition = -1;
        return this.advance();
    }

    private boolean advance() throws IOException {
        this.matchStartPosition = this.termSpans.start();
        this.matchDocNumber = this.termSpans.doc();
        this.isPayloadLoaded = false;
        return true;
    }

    private void loadPayload() {
        List payload;
        if (this.isPayloadLoaded) {
            return;
        }
        this.isPayloadLoaded = true;
        try {
            payload = (List)this.termSpans.getPayload();
        }
        catch (IOException e) {
            this.matchEndPosition = this.matchStartPosition;
            this.setSpanId((short)-1);
            this.hasSpanId = false;
            this.matchPayload = null;
            return;
        }
        if (!payload.isEmpty() && payload.get(0) != null) {
            int length = ((byte[])payload.get(0)).length;
            ByteBuffer bb = ByteBuffer.allocate(length);
            bb.put((byte[])payload.get(0));
            this.payloadTypeIdentifier = bb.get(0);
            if (this.payloadTypeIdentifier != PayloadTypeIdentifier.MILESTONE.value) {
                this.matchEndPosition = bb.getInt(9);
            }
            if (this.payloadTypeIdentifier == PayloadTypeIdentifier.ELEMENT.value && length > 15) {
                this.setSpanId(bb.getShort(14));
                this.hasSpanId = true;
            } else {
                this.setSpanId((short)-1);
                this.hasSpanId = false;
            }
            this.matchPayload = Collections.singletonList(bb.array());
            return;
        }
        this.matchEndPosition = this.matchStartPosition;
        this.setSpanId((short)-1);
        this.hasSpanId = false;
        this.matchPayload = null;
    }

    @Override
    public int end() {
        this.loadPayload();
        return this.matchEndPosition;
    }

    @Override
    public Collection<byte[]> getPayload() {
        this.loadPayload();
        return this.matchPayload;
    }

    @Override
    public boolean isPayloadAvailable() {
        this.loadPayload();
        return !this.matchPayload.isEmpty();
    }

    @Override
    public short getSpanId() {
        this.loadPayload();
        return this.spanId;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target && this.firstSpans.skipTo(target)) {
            return this.advance();
        }
        this.hasMoreSpans = false;
        this.matchPayload = null;
        return false;
    }

    @Override
    public long cost() {
        return this.termSpans.cost();
    }

    public static enum PayloadTypeIdentifier {
        ELEMENT(64),
        MILESTONE(65);

        private byte value;

        private PayloadTypeIdentifier(int value) {
            this.value = (byte)value;
        }
    }
}

