/*
 * Decompiled with CFR 0.152.
 */
package lemming.test.lemma.edit;

import java.util.LinkedList;
import lemming.lemma.LemmaCandidateSet;
import lemming.lemma.LemmaInstance;
import lemming.lemma.edit.EditTreeGenerator;
import lemming.lemma.edit.EditTreeGeneratorTrainer;
import org.junit.Assert;
import org.junit.Test;

public class EditTreeGeneratorTest {
    @Test
    public void test() {
        EditTreeGeneratorTrainer trainer = new EditTreeGeneratorTrainer();
        trainer.getOptions().setOption("tag-dependent", true);
        trainer.getOptions().setOption("min-count", 0);
        trainer.getOptions().setOption("num-steps", 1);
        LinkedList<LemmaInstance> instances = new LinkedList<LemmaInstance>();
        instances.add(new LemmaInstance("abc", "ab", null, "C"));
        instances.add(new LemmaInstance("dec", "de", null, "C"));
        instances.add(new LemmaInstance("ccc", "cc", null, "C"));
        instances.add(new LemmaInstance("abc", "abc", null, "B"));
        instances.add(new LemmaInstance("dec", "dec", null, "B"));
        instances.add(new LemmaInstance("dec", "decc", null, null));
        EditTreeGenerator gen = (EditTreeGenerator)trainer.train(instances, null);
        LemmaCandidateSet set = null;
        set = new LemmaCandidateSet();
        gen.addCandidates(new LemmaInstance("fgc", null, null, "C"), set);
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.contains("fg"));
        set = new LemmaCandidateSet();
        gen.addCandidates(new LemmaInstance("fgc", null, null, "B"), set);
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.contains("fgc"));
        set = new LemmaCandidateSet();
        gen.addCandidates(new LemmaInstance("fgc", null, null, null), set);
        Assert.assertEquals((long)3L, (long)set.size());
        Assert.assertTrue((boolean)set.contains("fgc"));
        Assert.assertTrue((boolean)set.contains("fg"));
        Assert.assertTrue((boolean)set.contains("fgcc"));
    }
}

