/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import java.util.ArrayList;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;

public class XSDList
extends SchemaElement {
    private SimpleTypeDefinition typeDefinition;
    private boolean foundItemType = false;

    @Override
    protected void prepareAttributes() throws SchemaException {
        String separator;
        this.typeDefinition = this.getContainingSimpleType();
        this.typeDefinition.setDerivationMethodName("list");
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"id", "itemType"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String itemTypeName = atts.getValue(NamespaceUri.NULL, "itemType");
        if (itemTypeName != null) {
            int itemTypeFingerprint;
            this.foundItemType = true;
            try {
                itemTypeFingerprint = this.getFingerprint(itemTypeName, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            if (itemTypeFingerprint == 634 || itemTypeFingerprint == 633) {
                this.warning("Type " + itemTypeName + " is recognized by Saxon but is not interoperable");
            } else if (itemTypeFingerprint == 573 || itemTypeFingerprint == 631 || itemTypeFingerprint == 630) {
                this.error("Type " + itemTypeName + " cannot be used as an item type");
            }
            TypeReference typeRef = new TypeReference(itemTypeFingerprint, (EnterpriseConfiguration)this.getConfiguration(), this);
            this.typeDefinition.setItemTypeReference(typeRef);
        }
        if ((separator = atts.getValue(NamespaceUri.SAXON, "separator")) != null) {
            ArrayList<String> warnings = new ArrayList<String>();
            try {
                RegularExpression regex = this.getConfiguration().compileRegularExpression(StringView.tidy(separator), "", "XSD11", warnings);
                if (regex.matches(EmptyUnicodeString.getInstance())) {
                    this.error("The regular expression in saxon:separator must not be one that matches a zero-length string");
                }
                for (String message : warnings) {
                    this.warning(message);
                }
                this.typeDefinition.setTokenSeparator(regex);
            }
            catch (XPathException e) {
                this.error("Error in saxon:separator regular expression: " + e.getMessage());
            }
        }
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        boolean foundAnnotation = false;
        boolean foundSimpleType = false;
        block4: for (NodeInfo nodeInfo : this.children()) {
            int fp = nodeInfo.getFingerprint();
            switch (fp) {
                case 578: {
                    if (foundSimpleType) {
                        this.mustBeFirstElement("annotation");
                    }
                    if (foundAnnotation) {
                        this.duplicateElement("annotation");
                    }
                    foundAnnotation = true;
                    continue block4;
                }
                case 621: {
                    if (this.foundItemType) {
                        this.mutuallyExclusiveElementAndAttribute("simpleType", "itemType");
                    }
                    if (foundSimpleType) {
                        this.duplicateElement("simpleType");
                    }
                    foundSimpleType = true;
                    continue block4;
                }
            }
            this.illegalElement(nodeInfo);
        }
        if (!this.foundItemType && !foundSimpleType) {
            String err = "A <list> element must either have an @itemType attribute or a <simpleType> child";
            this.error(err);
        }
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        for (NodeInfo nodeInfo : this.children()) {
            if (nodeInfo.getFingerprint() != 621) continue;
            SimpleTypeDefinition itemType = ((XSDSimpleType)nodeInfo).getSimpleTypeDefinition();
            TypeReference typeRef = new TypeReference(itemType.getFingerprint(), (EnterpriseConfiguration)this.getConfiguration(), nodeInfo);
            typeRef.setTarget(itemType);
            this.typeDefinition.setItemTypeReference(typeRef);
        }
    }
}

