/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.query.SpanRepetitionQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepetitionSpans
extends SimpleSpans {
    private final Logger log = LoggerFactory.getLogger(RepetitionSpans.class);
    public static final boolean DEBUG = false;
    private int min;
    private int max;
    private long matchCost;
    private List<CandidateSpan> matchList;
    private List<CandidateSpan> candidates;

    public RepetitionSpans(SpanRepetitionQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
        this.min = query.getMin();
        this.max = query.getMax();
        this.matchList = new ArrayList<CandidateSpan>();
        this.candidates = new ArrayList<CandidateSpan>();
        this.hasMoreSpans = this.firstSpans.next();
    }

    @Override
    public boolean next() throws IOException {
        this.isStartEnumeration = false;
        this.matchPayload.clear();
        return this.advance();
    }

    private boolean advance() throws IOException {
        while (this.hasMoreSpans || !this.matchList.isEmpty()) {
            if (!this.matchList.isEmpty()) {
                this.setMatchProperties(this.matchList.get(0));
                this.matchList.remove(0);
                return true;
            }
            this.matchCost = 0L;
            List<CandidateSpan> adjacentSpans = this.collectAdjacentSpans();
            this.setMatchList(adjacentSpans);
        }
        return false;
    }

    private List<CandidateSpan> collectAdjacentSpans() throws IOException {
        CandidateSpan cs;
        CandidateSpan startSpan;
        if (!this.candidates.isEmpty()) {
            startSpan = this.candidates.get(0);
            this.candidates.remove(0);
        } else {
            startSpan = new CandidateSpan(this.firstSpans);
        }
        ArrayList<CandidateSpan> adjacentSpans = new ArrayList<CandidateSpan>();
        adjacentSpans.add(startSpan);
        CandidateSpan prevSpan = startSpan;
        for (int i = 0; i < this.candidates.size() && (cs = this.candidates.get(i)).getStart() <= prevSpan.getEnd(); ++i) {
            if (startSpan.getDoc() != cs.getDoc() || cs.getStart() != prevSpan.getEnd()) continue;
            prevSpan = cs;
            adjacentSpans.add(prevSpan);
        }
        while ((this.hasMoreSpans = this.firstSpans.next()) && startSpan.getDoc() == this.firstSpans.doc()) {
            if (this.firstSpans.start() > prevSpan.getEnd()) {
                this.candidates.add(new CandidateSpan(this.firstSpans));
                break;
            }
            if (this.firstSpans.start() == prevSpan.getEnd()) {
                prevSpan = new CandidateSpan(this.firstSpans);
                adjacentSpans.add(prevSpan);
                continue;
            }
            this.candidates.add(new CandidateSpan(this.firstSpans));
        }
        return adjacentSpans;
    }

    private void setMatchList(List<CandidateSpan> adjacentSpans) {
        for (int i = this.min; i < this.max + 1; ++i) {
            int endIndex;
            int j = 0;
            while ((endIndex = j + i - 1) < adjacentSpans.size()) {
                CandidateSpan startSpan = adjacentSpans.get(j);
                if (i == 1) {
                    try {
                        matchSpan = startSpan.clone();
                        matchSpan.setPayloads(this.computeMatchPayload(adjacentSpans, 0, endIndex - 1));
                        this.matchList.add(matchSpan);
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                } else {
                    CandidateSpan endSpan = adjacentSpans.get(endIndex);
                    matchSpan = new CandidateSpan(startSpan.getStart(), endSpan.getEnd(), startSpan.getDoc(), this.computeMatchCost(adjacentSpans, 0, endIndex), this.computeMatchPayload(adjacentSpans, 0, endIndex));
                    this.matchList.add(matchSpan);
                }
                ++j;
            }
        }
        Collections.sort(this.matchList);
    }

    private Collection<byte[]> computeMatchPayload(List<CandidateSpan> adjacentSpans, int start, int end) {
        ArrayList<byte[]> payload = new ArrayList<byte[]>();
        for (int i = start; i <= end; ++i) {
            payload.addAll(adjacentSpans.get(i).getPayloads());
        }
        return payload;
    }

    private long computeMatchCost(List<CandidateSpan> adjacentSpans, int start, int end) {
        long matchCost = 0L;
        for (int i = start; i <= end; ++i) {
            matchCost += adjacentSpans.get(i).getCost();
        }
        return matchCost;
    }

    private void setMatchProperties(CandidateSpan candidateSpan) throws IOException {
        this.matchDocNumber = candidateSpan.getDoc();
        this.matchStartPosition = candidateSpan.getStart();
        this.matchEndPosition = candidateSpan.getEnd();
        if (this.collectPayloads && candidateSpan.getPayloads() != null) {
            this.matchPayload.addAll(candidateSpan.getPayloads());
        }
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        this.matchDocNumber = -1;
        this.matchStartPosition = -1;
        this.matchEndPosition = -1;
        if (!this.candidates.isEmpty()) {
            Iterator<CandidateSpan> i = this.candidates.iterator();
            while (i.hasNext()) {
                CandidateSpan cs = i.next();
                if (cs.getDoc() < target) {
                    i.remove();
                    continue;
                }
                if (cs.getDoc() != target) continue;
                this.matchList.clear();
                return this.advance();
            }
        }
        if (this.hasMoreSpans && this.firstSpans.doc() < target && !this.firstSpans.skipTo(target)) {
            this.hasMoreSpans = false;
            return false;
        }
        this.matchList.clear();
        return this.advance();
    }

    @Override
    public long cost() {
        return this.matchCost;
    }
}

