/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.validate.ValidatingFilter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class IdValidator
extends ValidatingFilter {
    private Stack<Set<String>> stack = new Stack();
    private int level = 0;
    private HashSet<String> idValues = new HashSet(100);
    private HashSet<String> unresolvedRefs = new HashSet(100);
    private IdValueChecker currentElementChecker = null;
    private FastStringBuffer buffer = new FastStringBuffer(64);
    private Location textLocationId = ExplicitLocation.UNKNOWN_LOCATION;
    private Map<SchemaType, IdValueChecker> checkerMap = new HashMap<SchemaType, IdValueChecker>(10);
    private static NonIdChecker SINGLETON_NON_ID_CHECKER = new NonIdChecker();

    public IdValidator(Receiver next) {
        super(next);
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.currentElementChecker = this.checkerMap.get(typeCode);
        if (this.currentElementChecker == null) {
            this.currentElementChecker = this.allocateChecker(typeCode);
            this.checkerMap.put(typeCode, this.currentElementChecker);
        }
        if (this.currentElementChecker == SINGLETON_NON_ID_CHECKER) {
            this.currentElementChecker = null;
        }
        this.stack.push(new HashSet(4));
        ++this.level;
        this.nextReceiver.startElement(nameCode, typeCode, location, properties);
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.currentElementChecker != null) {
            this.buffer.append(chars);
        }
        this.nextReceiver.characters(chars, locationId, properties);
        this.textLocationId = locationId;
    }

    @Override
    public void endElement() throws XPathException {
        --this.level;
        this.stack.pop();
        if (this.currentElementChecker != null) {
            this.currentElementChecker.checkValue(this.buffer, this.textLocationId);
        }
        this.buffer.setLength(0);
        this.currentElementChecker = null;
        this.nextReceiver.endElement();
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType type, CharSequence value, Location locationId, int properties) throws XPathException {
        IdValueChecker checker = this.checkerMap.get(type);
        if (checker == null) {
            checker = this.allocateChecker(type);
            this.checkerMap.put(type, checker);
        }
        checker.checkValue(value, locationId);
        this.nextReceiver.attribute(nameCode, type, value, locationId, properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IdValueChecker allocateChecker(SchemaType type) throws MissingComponentException {
        SimpleType stype;
        int fingerprint = type.getFingerprint();
        switch (fingerprint) {
            case 560: {
                return new SimpleIdChecker();
            }
            case 561: {
                return new SimpleIdrefChecker();
            }
            case 562: {
                return new IdrefListChecker();
            }
        }
        if (fingerprint < 1023) {
            return SINGLETON_NON_ID_CHECKER;
        }
        Configuration config = this.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        if (type.isComplexType()) {
            if (!((ComplexType)type).isSimpleContent()) return SINGLETON_NON_ID_CHECKER;
            stype = ((ComplexType)type).getSimpleContentType();
            assert (stype != null);
        } else {
            stype = (SimpleType)type;
        }
        if (type.isAtomicType()) {
            if (type.isIdType()) {
                return new SimpleIdChecker();
            }
            if (!type.isIdRefType()) return SINGLETON_NON_ID_CHECKER;
            return new SimpleIdrefChecker();
        }
        if (stype.isListType()) {
            SimpleType componentType = ((ListType)stype).getItemType();
            if (componentType instanceof AtomicType && th.isSubType((AtomicType)componentType, BuiltInAtomicType.ID)) {
                return new IdListChecker();
            }
            if (componentType instanceof AtomicType && th.isSubType((AtomicType)componentType, BuiltInAtomicType.IDREF)) {
                return new IdrefListChecker();
            }
            if (!type.isIdType() && !type.isIdRefType()) return SINGLETON_NON_ID_CHECKER;
            return new UnionChecker(stype);
        }
        if (!type.isIdType() && !type.isIdRefType()) return SINGLETON_NON_ID_CHECKER;
        return new UnionChecker(stype);
    }

    @Override
    public void endDocument() throws XPathException {
        this.checkUnresolvedRefs();
        this.nextReceiver.endDocument();
    }

    @Override
    public void close() throws XPathException {
        this.nextReceiver.close();
    }

    private void checkUnresolvedRefs() throws XPathException {
        if (!this.unresolvedRefs.isEmpty()) {
            String value;
            String howMany;
            int count = this.unresolvedRefs.size();
            if (count == 1) {
                howMany = " is one";
                value = "value";
            } else {
                Numberer_en num = new Numberer_en();
                num.setTensUnitsSeparatorCardinal("-");
                howMany = " are " + num.toWords(count, 1);
                value = "values";
            }
            StringBuilder err = new StringBuilder("There" + howMany + " IDREF " + value + " with no corresponding ID");
            if (count > 10) {
                err.append(". First ten:");
            } else {
                err.append(':');
            }
            int i = 0;
            for (String id : this.unresolvedRefs) {
                err.append("\n    ");
                err.append(id);
                if (i++ <= 9) continue;
                break;
            }
            ValidationFailure ve = new ValidationFailure(err.toString());
            int hostLanguage = this.getPipelineConfiguration().getHostLanguage();
            if (hostLanguage == 50) {
                ve.setErrorCode("XTTE1555");
            } else if (hostLanguage == 51) {
                ve.setErrorCode("XQDY0027");
            }
            ve.setConstraintReference(1, "cvc-id", "1");
            this.reportValidationError(ve, ExplicitLocation.UNKNOWN_LOCATION);
            throw ve.makeException();
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    protected void reportValidationError(ValidationFailure err, Location locationId) throws XPathException {
        PipelineConfiguration pipe = this.getPipelineConfiguration();
        if (err.getErrorCodeQName() == null) {
            int language = pipe.getHostLanguage();
            if (language == 50) {
                err.setErrorCode("XTTE1555");
            } else if (language == 51) {
                err.setErrorCode("XQDY0027");
            }
        }
        super.reportValidationError(err, false, locationId);
    }

    private void processId(String id, Location locationId) throws XPathException {
        if (this.level == 0) {
            ValidationFailure ve = new ValidationFailure("An element of type xs:ID must have a parent element within the tree being validated");
            int hostLanguage = this.getPipelineConfiguration().getHostLanguage();
            if (hostLanguage == 50) {
                ve.setErrorCode("XTTE1555");
            } else if (hostLanguage == 51) {
                ve.setErrorCode("XQDY0027");
            }
            ve.setConstraintReference(1, "cvc-id", "2");
            this.reportValidationError(ve, locationId);
            throw ve.makeException();
        }
        if (this.idValues.contains(id)) {
            Set idsForElement = (Set)this.stack.get(this.level - 1);
            if (this.getConfiguration().getXsdVersion() == 10 || !idsForElement.contains(id)) {
                ValidationFailure ve = new ValidationFailure("ID value '" + id + "' is not unique");
                int hostLanguage = this.getPipelineConfiguration().getHostLanguage();
                if (hostLanguage == 50) {
                    ve.setErrorCode("XTTE1555");
                } else if (hostLanguage == 51) {
                    ve.setErrorCode("XQDY0027");
                }
                ve.setConstraintReference(1, "cvc-id", "2");
                this.reportValidationError(ve, locationId);
                throw ve.makeException();
            }
        } else {
            this.idValues.add(id);
            if (this.level >= 1) {
                ((Set)this.stack.get(this.level - 1)).add(id);
            }
        }
        this.unresolvedRefs.remove(id);
    }

    private static class NonIdChecker
    implements IdValueChecker {
        private NonIdChecker() {
        }

        @Override
        public void checkValue(CharSequence value, Location locationId) {
        }
    }

    private class UnionChecker
    implements IdValueChecker {
        private SimpleType type;

        public UnionChecker(SimpleType type) {
            this.type = type;
        }

        @Override
        public void checkValue(CharSequence value, Location locationId) throws XPathException {
            Configuration config = IdValidator.this.getConfiguration();
            TypeHierarchy th = config.getTypeHierarchy();
            AtomicSequence typedValue = this.type.getTypedValue(value, DummyNamespaceResolver.getInstance(), config.getConversionRules());
            for (AtomicValue val : typedValue) {
                AtomicType itemType = val.getItemType();
                if (th.isSubType(itemType, BuiltInAtomicType.ID)) {
                    IdValidator.this.processId(val.getStringValue(), locationId);
                    continue;
                }
                if (!th.isSubType(itemType, BuiltInAtomicType.IDREF)) continue;
                String idref = val.getStringValue();
                if (IdValidator.this.idValues.contains(idref)) continue;
                IdValidator.this.unresolvedRefs.add(idref);
            }
        }
    }

    private class IdrefListChecker
    implements IdValueChecker {
        private IdrefListChecker() {
        }

        @Override
        public void checkValue(CharSequence value, Location locationId) {
            String ids = value.toString();
            StringTokenizer tok = new StringTokenizer(ids, " \t\n\r", false);
            while (tok.hasMoreTokens()) {
                String id = tok.nextToken();
                if (IdValidator.this.idValues.contains(id)) continue;
                IdValidator.this.unresolvedRefs.add(id);
            }
        }
    }

    private class IdListChecker
    implements IdValueChecker {
        private IdListChecker() {
        }

        @Override
        public void checkValue(CharSequence value, Location locationId) throws XPathException {
            String ids = value.toString();
            StringTokenizer tok = new StringTokenizer(ids, " \t\n\r", false);
            while (tok.hasMoreTokens()) {
                String id = tok.nextToken();
                IdValidator.this.processId(id, locationId);
            }
        }
    }

    private class SimpleIdrefChecker
    implements IdValueChecker {
        private SimpleIdrefChecker() {
        }

        @Override
        public void checkValue(CharSequence value, Location locationId) {
            String id = Whitespace.trimWhitespace(value).toString();
            if (!id.isEmpty() && !IdValidator.this.idValues.contains(id)) {
                IdValidator.this.unresolvedRefs.add(id);
            }
        }
    }

    private class SimpleIdChecker
    implements IdValueChecker {
        private SimpleIdChecker() {
        }

        @Override
        public void checkValue(CharSequence value, Location locationId) throws XPathException {
            String id = Whitespace.trimWhitespace(value).toString();
            IdValidator.this.processId(id, locationId);
        }
    }

    private static interface IdValueChecker {
        public void checkValue(CharSequence var1, Location var2) throws XPathException;
    }
}

