/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.StartTagBuffer;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.Statistics;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public class StartTagBufferEE
extends StartTagBuffer {
    private Stack<AttributeCollection> stack = new Stack();
    private boolean empty = true;
    private NodeInfo elementNode;

    public StartTagBufferEE(Receiver next) {
        super(next);
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.stack.push(AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION);
        this.elementNode = null;
        super.startElement(nameCode, typeCode, location, properties);
    }

    @Override
    public void endElement() throws XPathException {
        this.stack.pop();
        super.endElement();
    }

    public void notifyInheritableAttribute(NodeName nameCode, String value, Location location, int properties) {
        AttributeCollection atts = this.stack.peek();
        if (atts == AttributeCollectionImpl.EMPTY_ATTRIBUTE_COLLECTION) {
            this.stack.pop();
            atts = new AttributeCollectionImpl(this.getConfiguration());
            this.stack.push(atts);
        }
        ((AttributeCollectionImpl)atts).addAttribute(nameCode, BuiltInAtomicType.UNTYPED_ATOMIC, value, location, properties);
        this.empty = false;
    }

    public void gatherInheritedAttributes(AttributeCollectionImpl atts) {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            AttributeCollection ac = (AttributeCollection)this.stack.get(i);
            for (int j = 0; j < ac.getLength(); ++j) {
                NodeName nc = ac.getNodeName(j);
                if (atts.findByNodeName(nc) != -1) continue;
                atts.addAttribute(nc, BuiltInAtomicType.UNTYPED_ATOMIC, ac.getValue(j), ac.getLocation(j), ac.getProperties(j));
            }
        }
    }

    public boolean hasInheritedAttributes() {
        return !this.empty;
    }

    public NodeInfo createSkeletonElementNode() throws XPathException {
        if (this.elementNode == null) {
            int len = this.bufferedAttributes.getLength();
            TinyBuilder builder = new TinyBuilder(this.getPipelineConfiguration());
            builder.setSystemId(this.systemId);
            Statistics stats = new Statistics(2, len + 2, this.namespacesSize + 2, 16);
            builder.setStatistics(stats);
            builder.open();
            builder.startElement(this.elementNameCode, Untyped.getInstance(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            for (int i = 0; i < this.namespacesSize; ++i) {
                builder.namespace(this.namespaces[i], 0);
            }
            AttributeCollectionImpl allAttributes = this.bufferedAttributes;
            if (this.hasInheritedAttributes()) {
                allAttributes = this.bufferedAttributes.getLength() == 0 ? new AttributeCollectionImpl(this.getConfiguration()) : AttributeCollectionImpl.copy(this.bufferedAttributes);
                this.gatherInheritedAttributes(allAttributes);
            }
            for (int i = 0; i < allAttributes.getLength(); ++i) {
                builder.attribute(allAttributes.getNodeName(i), BuiltInAtomicType.UNTYPED_ATOMIC, allAttributes.getValue(i), ExplicitLocation.UNKNOWN_LOCATION, 0);
            }
            builder.startContent();
            builder.endElement();
            this.elementNode = builder.getCurrentRoot();
        }
        return this.elementNode;
    }
}

