/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter;

import chipmunk.segmenter.SegmentationReading;
import chipmunk.segmenter.StringNormalizer;
import chipmunk.segmenter.TagSet;
import chipmunk.segmenter.Word;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marmot.util.LineIterator;

public class SegmentationDataReader
implements Iterable<Word> {
    private List<Word> words_;
    private int tag_level_;
    private StringNormalizer normalizer_;
    private Map<String, Word> vocab_;
    private String filepath_;

    public SegmentationDataReader(String filepath, String lang, int tag_level) {
        this.normalizer_ = StringNormalizer.labeledCreate(lang);
        this.tag_level_ = tag_level;
        this.filepath_ = filepath;
        this.words_ = null;
        this.vocab_ = null;
    }

    public List<Word> map(List<Word> words) {
        this.getData();
        LinkedList<Word> new_words = new LinkedList<Word>();
        for (Word word : words) {
            Word new_word = this.vocab_.get(word.getWord());
            assert (new_word != null);
            new_words.add(new_word);
        }
        return new_words;
    }

    public List<Word> getData() {
        if (this.words_ == null) {
            this.vocab_ = new HashMap<String, Word>();
            this.words_ = new LinkedList<Word>();
            for (Word word : this) {
                this.words_.add(word);
            }
        }
        return this.words_;
    }

    @Override
    public Iterator<Word> iterator() {
        final LineIterator iterator2 = new LineIterator(this.filepath_, "\t");
        return new Iterator<Word>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public Word next() {
                Object line = iterator2.next();
                assert (line.size() == 2);
                String word_string = (String)line.get(0);
                word_string = SegmentationDataReader.this.normalizer_.normalize(word_string);
                Word word = null;
                if (SegmentationDataReader.this.vocab_ != null) {
                    word = SegmentationDataReader.this.vocab_.get(word_string);
                }
                if (word == null) {
                    word = new Word(word_string);
                    if (SegmentationDataReader.this.vocab_ != null) {
                        SegmentationDataReader.this.vocab_.put(word_string, word);
                    }
                }
                if (line.size() > 1) {
                    SegmentationDataReader.this.addReading(word, (String)line.get(1));
                }
                return word;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void addReading(Word word, String reading_string) {
        String[] word_readings;
        for (String word_reading : word_readings = reading_string.split(", ")) {
            String[] readings = word_reading.split(" ");
            LinkedList<String> segments = new LinkedList<String>();
            LinkedList<String> tags = new LinkedList<String>();
            for (String reading : readings) {
                String tag;
                String segment;
                int index = -1;
                for (int i = 0; i < reading.length(); ++i) {
                    char c = reading.charAt(i);
                    if (c != ':') continue;
                    index = i;
                    if (i + 1 >= reading.length() || reading.charAt(i + 1) != ':') break;
                    index = i + 1;
                    break;
                }
                if (index < 0 || index == reading.length() - 1) {
                    segment = reading;
                    tag = null;
                } else {
                    segment = reading.substring(0, index);
                    tag = reading.substring(index + 1);
                }
                segment = this.normalizer_.normalize(segment);
                tag = TagSet.getTag(tag, this.tag_level_);
                segments.add(segment);
                tags.add(tag);
            }
            StringBuilder rejoint_word = new StringBuilder(word.getLength());
            for (String segment : segments) {
                rejoint_word.append(segment);
            }
            assert (rejoint_word.toString().equals(word.getWord())) : reading_string + " " + segments;
            word.add(new SegmentationReading(segments, tags));
        }
    }
}

