/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.functions.AccessorFn;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class AccessorFnCompiler
extends ToItemCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        AccessorFn fn = (AccessorFn)fnc.getTargetFunction();
        AccessorFnCompiler.visitAnnotation(compiler, "AccessorFn Expr:" + fn.getFunctionName().getDisplayName());
        LabelInfo accessorReturn = methodInfo.newLabel("accessorReturn");
        compiler.compileToItem(fnc.getArg(0));
        if (Cardinality.allowsZero(fnc.getArg(0).getCardinality())) {
            ga.dup();
            ga.ifNull(accessorReturn.label());
        }
        ga.checkClass(AtomicValue.class);
        AccessorFnCompiler.allocateStatic(compiler, (Object)fn.getComponentId());
        ga.invokeInstanceMethod(AtomicValue.class, "getComponent", AccessorFn.Component.class);
        methodInfo.placeLabel(accessorReturn);
    }
}

