/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.VariableReferenceCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;

public class CallableExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        ArrayList<Expression> subExpressions = new ArrayList<Expression>(5);
        for (Operand o : expression.operands()) {
            subExpressions.add(o.getChildExpression());
        }
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        CallableExpressionCompiler.visitAnnotation(compiler, "CallableExpressionCompiler - " + expression.getExpressionName());
        CallableExpressionCompiler.visitLineNumber(compiler, ga, expression);
        int arrVar = CallableExpressionCompiler.buildArgumentArray(compiler, ga, methodInfo, subExpressions);
        CallableExpressionCompiler.allocateStatic(compiler, expression);
        compiler.generateGetContext();
        ga.loadLocal(arrVar);
        ga.invokeInstanceMethod(Callable.class, "call", XPathContext.class, Sequence[].class);
        ga.invokeInstanceMethod(Sequence.class, "iterate", new Class[0]);
        CallableExpressionCompiler.visitAnnotation(compiler, "CallableCompiler-Done");
    }

    public static int buildArgumentArray(CompilerService compiler, Generator ga, GeneratedMethodInfo methodInfo, List<Expression> subExpressions) throws CannotCompileException {
        int len = subExpressions.size();
        ga.push(len);
        ga.newArray(Type.getType(Sequence.class));
        int arrVar = methodInfo.allocateLocal(Sequence[].class);
        ga.storeLocal(arrVar);
        CallableExpressionCompiler.visitAnnotation(compiler, "CallableCompiler-ArrayCreated");
        int i = 0;
        for (Expression expr : subExpressions) {
            ga.loadLocal(arrVar);
            ga.push(i++);
            if (!Cardinality.allowsMany(expr.getCardinality())) {
                compiler.compileToItem(expr);
                if (Cardinality.allowsZero(expr.getCardinality())) {
                    ga.dup();
                    LabelInfo notNull = methodInfo.newLabel("notNull");
                    ga.ifNonNull(notNull.label());
                    ga.pop();
                    CallableExpressionCompiler.allocateStatic(compiler, EmptySequence.getInstance());
                    methodInfo.placeLabel(notNull);
                }
            } else if (expr instanceof VariableReference) {
                VariableReferenceCompiler.compileToSequence(compiler, (VariableReference)expr);
            } else {
                compiler.compileToIterator(expr);
                ga.invokeStaticMethod(SequenceTool.class, "toLazySequence", SequenceIterator.class);
            }
            CallableExpressionCompiler.visitAnnotation(compiler, "CallableCompiler-SetArg" + (i - 1));
            ga.arrayStore(Type.getType(Sequence.class));
        }
        return arrVar;
    }
}

