/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToBooleanCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import java.util.Stack;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.functions.StartsWith;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.value.Cardinality;

public class StartsWithCompiler
extends ToBooleanCompiler {
    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        SystemFunctionCall fnc = (SystemFunctionCall)expression;
        CollatingFunctionFixed function = (CollatingFunctionFixed)fnc.getTargetFunction();
        boolean isStartsWith = function instanceof StartsWith;
        Expression arg0 = fnc.getArg(0);
        Expression arg1 = fnc.getArg(1);
        SubstringMatcher stringCollator = (SubstringMatcher)function.getStringCollator();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        StartsWithCompiler.visitAnnotation(compiler, isStartsWith ? "StartsWithCompiler" : "EndsWithCompiler");
        StartsWithCompiler.visitLineNumber(compiler, ga, expression);
        LabelInfo end = methodInfo.newLabel(isStartsWith ? "endStartsWith" : "endEndsWith");
        LabelInfo returnTrue = methodInfo.newLabel("returnTrue");
        LabelInfo returnFalse = methodInfo.newLabel("returnFalse");
        LabelInfo returnTrue1 = methodInfo.newLabel("returnTrue1");
        LabelInfo returnFalse1 = methodInfo.newLabel("returnFalse1");
        Stack<Class> unwindStack = new Stack<Class>();
        if (!(stringCollator instanceof CodepointCollator)) {
            StartsWithCompiler.allocateStatic(compiler, stringCollator);
            unwindStack.push(StringCollator.class);
        }
        compiler.compileToPrimitive(arg1, String.class, new OnEmpty.UnwindAndJump(unwindStack, returnTrue));
        unwindStack.push(String.class);
        if (Cardinality.allowsZero(arg1.getCardinality())) {
            ga.dup();
            ga.ifNull(returnTrue1.label());
        }
        if (!(arg1 instanceof StringLiteral) || ((StringLiteral)arg1).getStringValue().isEmpty()) {
            ga.dup();
            ga.invokeInstanceMethod(String.class, "length", new Class[0]);
            ga.ifZCmp(153, returnTrue1.label());
        }
        compiler.compileToPrimitive(arg0, String.class, new OnEmpty.UnwindAndJump(unwindStack, returnFalse));
        unwindStack.push(String.class);
        if (Cardinality.allowsZero(arg1.getCardinality())) {
            ga.dup();
            ga.ifNull(returnFalse1.label());
        }
        if (!(arg1 instanceof StringLiteral) || ((StringLiteral)arg1).getStringValue().isEmpty()) {
            ga.dup();
            ga.invokeInstanceMethod(String.class, "length", new Class[0]);
            ga.ifZCmp(153, returnFalse1.label());
        }
        ga.swap();
        if (stringCollator instanceof CodepointCollator) {
            if (isStartsWith) {
                ga.push(0);
                ga.invokeInstanceMethod(String.class, "startsWith", String.class, Integer.TYPE);
            } else {
                ga.invokeInstanceMethod(String.class, "endsWith", String.class);
            }
            ga.goTo(end);
        } else {
            ga.invokeInstanceMethod(SubstringMatcher.class, isStartsWith ? "startsWith" : "endsWith", String.class, String.class);
            ga.goTo(end);
        }
        methodInfo.placeLabel(returnTrue1);
        if (!(stringCollator instanceof CodepointCollator)) {
            ga.pop();
        }
        ga.pop();
        ga.goTo(returnTrue);
        methodInfo.placeLabel(returnFalse1);
        ga.pop();
        if (!(stringCollator instanceof CodepointCollator)) {
            ga.pop();
        }
        ga.pop();
        methodInfo.placeLabel(returnFalse);
        ga.push(false);
        ga.goTo(end);
        methodInfo.placeLabel(returnTrue);
        ga.push(true);
        methodInfo.placeLabel(end);
    }
}

