/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.feed.DecomposingFeed;
import com.saxonica.ee.stream.feed.SnapshotFeed;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.PatternWatch;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRule;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.Evaluator;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.ObjectValue;

public class AccumulatorWatch
extends PatternWatch {
    private Accumulator accumulator;
    private SimpleMode preDescentMode;
    private SimpleMode postDescentMode;
    private Stack<Sequence<?>> preDescentStack = new Stack();
    private Stack<SequenceOutputter> captureStack = new Stack();
    private Stack<FleetingNode> nodeStack = new Stack();
    private Sequence<?> currentValue;
    private boolean donePostDescent = false;
    private FleetingNode lastPredescentNode = null;
    private FleetingNode currentPredescentNode = null;
    private XPathContextMajor context;
    private WatchManager watchManager;

    public AccumulatorWatch(Accumulator accumulator) {
        this.accumulator = accumulator;
        this.preDescentMode = accumulator.getPreDescentRules();
        this.postDescentMode = accumulator.getPostDescentRules();
        this.setSelection(new NodeTestPattern(AnyNodeTest.getInstance()));
    }

    public Accumulator getAccumulator() {
        return this.accumulator;
    }

    public XPathContext getContext() {
        return this.context;
    }

    public FleetingNode getLastPredescentNode() {
        return this.lastPredescentNode;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        this.context = this.watchManager.getXPathContext().newCleanContext();
        this.context.setCurrentComponent(this.accumulator.getDeclaringComponent());
        SlotManager slotManager = this.accumulator.getSlotManagerForInitialValueExpression();
        this.context.setStackFrame(slotManager, SequenceTool.makeSequenceArray(slotManager.getNumberOfVariables()));
        this.context.setCurrentIterator(new ManualIterator());
        try {
            this.currentValue = ExpressionTool.eagerEvaluate(this.accumulator.getInitialValueExpression(), this.getContext());
        }
        catch (XPathException err) {
            this.currentValue = new ObjectValue<XPathException>(err);
        }
    }

    public void setWatchManager(WatchManager watchManager) {
        this.watchManager = watchManager;
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        Rule capture;
        int nodeNr = node.getNodeNumber();
        if (this.lastPredescentNode != null && nodeNr == this.lastPredescentNode.getNodeNumber()) {
            return null;
        }
        this.lastPredescentNode = node;
        this.currentPredescentNode = node;
        ManualIterator iter = (ManualIterator)this.context.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        Rule rule = this.preDescentMode.getRule(node, this.context);
        Sequence<?> value = this.currentValue;
        if (rule != null) {
            this.currentValue = value = this.applyRule(node, rule);
            if (this.accumulator.isTracing()) {
                this.context.getConfiguration().getLogger().info(this.accumulator.getAccumulatorName().getDisplayName() + " BEFORE " + Navigator.getPath(node) + ": " + Err.depictSequence(value));
            }
        }
        if ((capture = this.postDescentMode.getRule(node, this.context)) != null && ((AccumulatorRule)capture.getAction()).isCapturing()) {
            SequenceOutputter so = new SequenceOutputter(this.getPipelineConfiguration());
            DecomposingFeed feed = new DecomposingFeed(so);
            Trigger snapshotWatch = SnapshotFeed.getWatch(feed, AnchorPattern.getInstance(), this.watchManager, this.context);
            this.watchManager.addWatch(snapshotWatch, true);
            this.captureStack.push(so);
        }
        int depth = this.nodeStack.size();
        this.nodeStack.push(node);
        AccumulatorWatch.setAtDepth(this.preDescentStack, depth, value);
        this.donePostDescent = false;
        this.currentPredescentNode = null;
        return null;
    }

    private Sequence<?> applyRule(FleetingNode node, Rule rule) throws XPathException {
        if (this.currentValue instanceof ExternalObject && ((ExternalObject)this.currentValue).getObject() instanceof XPathException) {
            return this.currentValue;
        }
        AccumulatorRule target = (AccumulatorRule)rule.getAction();
        Expression delta = target.getNewValueExpression();
        XPathContextMajor c2 = this.context.newCleanContext();
        Controller controller = c2.getController();
        assert (controller != null);
        NodeInfo targetNode = node;
        if (target.isPostDescent() && target.isCapturing()) {
            targetNode = (NodeInfo)this.captureStack.pop().getFirstItem();
        }
        ManualIterator<FleetingNode> initialNode = new ManualIterator<FleetingNode>((FleetingNode)targetNode);
        c2.setCurrentIterator(initialNode);
        c2.openStackFrame(target.getStackFrameMap());
        c2.setLocalVariable(0, this.currentValue);
        c2.setCurrentComponent(this.accumulator.getDeclaringComponent());
        c2.setTemporaryOutputState(130);
        try {
            return Evaluator.EAGER_SEQUENCE.evaluate(delta, c2);
        }
        catch (XPathException e) {
            return new ObjectValue<XPathException>(e);
        }
    }

    private static void setAtDepth(Stack<Sequence<?>> stack, int depth, Sequence<?> value) {
        if (depth >= stack.size()) {
            stack.push(value);
        } else {
            stack.set(depth, value);
        }
    }

    public FleetingNode getCurrentPredescentNode() {
        return this.currentPredescentNode;
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        FleetingNode node = (FleetingNode)item;
        if (node.getNodeKind() == 2) {
            return;
        }
        ManualIterator iter = (ManualIterator)this.context.getCurrentIterator();
        iter.setContextItem(item);
        iter.incrementPosition();
        int nodeNr = node.getNodeNumber();
        if (this.lastPredescentNode != null && nodeNr == this.lastPredescentNode.getNodeNumber()) {
            return;
        }
        this.lastPredescentNode = node;
        Rule rule = this.preDescentMode.getRule(item, this.context);
        if (rule != null) {
            this.currentValue = this.applyRule(node, rule);
            if (this.accumulator.isTracing()) {
                this.context.getConfiguration().getLogger().info(this.accumulator.getAccumulatorName().getDisplayName() + " BEFORE " + Navigator.getPath(node) + ": " + Err.depictSequence(this.currentValue));
            }
        }
        int depth = this.nodeStack.size();
        AccumulatorWatch.setAtDepth(this.preDescentStack, depth, this.currentValue);
        rule = this.postDescentMode.getRule(item, this.context);
        if (rule != null) {
            this.currentValue = this.applyRule(node, rule);
            if (this.accumulator.isTracing()) {
                this.context.getConfiguration().getLogger().info(this.accumulator.getAccumulatorName().getDisplayName() + " AFTER " + Navigator.getPath(node) + ": " + Err.depictSequence(this.currentValue));
            }
        }
        this.donePostDescent = true;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        FleetingNode node = this.nodeStack.pop();
        Rule rule = this.postDescentMode.getRule(node, this.context);
        if (rule != null) {
            this.currentValue = this.applyRule(node, rule);
            if (this.accumulator.isTracing()) {
                this.context.getConfiguration().getLogger().info(this.accumulator.getAccumulatorName().getDisplayName() + " AFTER " + Navigator.getPath(node) + ": " + Err.depictSequence(this.currentValue));
            }
        }
        this.donePostDescent = true;
    }

    @Override
    public void close() throws XPathException {
    }

    public Sequence<?> getPreDescentValue(FleetingNode node) throws XPathException {
        if (node.getNodeNumber() > this.lastPredescentNode.getNodeNumber()) {
            if (node instanceof FleetingParentNode) {
                this.startSelectedParentNode((FleetingParentNode)node, ExplicitLocation.UNKNOWN_LOCATION);
            } else {
                this.processItem(node);
            }
        }
        this.detectErrorValue(this.currentValue);
        Sequence value = (Sequence)this.preDescentStack.get(node.getDepth());
        this.detectErrorValue(value);
        return value;
    }

    private void detectErrorValue(Sequence<?> value) throws XPathException {
        if (value instanceof ExternalObject && ((ExternalObject)value).getObject() instanceof XPathException) {
            throw (XPathException)((ExternalObject)value).getObject();
        }
    }

    public Sequence<?> getPreDescentValueAtDepth(int depth) throws XPathException {
        Sequence value = (Sequence)this.preDescentStack.get(depth);
        if (value instanceof ExternalObject && ((ExternalObject)value).getObject() instanceof XPathException) {
            throw (XPathException)((ExternalObject)value).getObject();
        }
        return value;
    }

    public Sequence<?> getPostDescentValue() throws XPathException {
        Sequence<?> value = this.currentValue;
        if (value instanceof ExternalObject && ((ExternalObject)value).getObject() instanceof XPathException) {
            throw (XPathException)((ExternalObject)value).getObject();
        }
        return value;
    }

    public boolean isDonePostDescent() {
        return this.donePostDescent;
    }
}

