/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.jdom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Query;
import net.sf.saxon.option.jdom.JDOMDocumentWrapper;
import net.sf.saxon.trans.XPathException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class JDOMQuery
extends Query {
    public List preprocess(List sources) throws XPathException {
        try {
            ArrayList<JDOMDocumentWrapper> jdomSources = new ArrayList<JDOMDocumentWrapper>(sources.size());
            for (Object source : sources) {
                SAXSource ss = (SAXSource)source;
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(ss.getInputSource());
                doc.setBaseURI(((SAXSource)source).getSystemId());
                JDOMDocumentWrapper jdom = new JDOMDocumentWrapper(doc, this.getConfiguration());
                jdomSources.add(jdom);
            }
            return jdomSources;
        }
        catch (JDOMException e) {
            throw new XPathException(e);
        }
        catch (IOException e) {
            throw new XPathException(e);
        }
    }

    public static void main(String[] args) {
        new JDOMQuery().doQuery(args, "JDOMQuery");
    }
}

