/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TotalDigitsFacet;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public abstract class DigitsFacet
extends Facet {
    private int requiredValue;

    public abstract void setValue(String var1) throws SchemaException;

    @Override
    public String getValue() {
        return this.requiredValue + "";
    }

    public int getNumericValue() {
        return this.requiredValue;
    }

    public void setNumericValue(int value) {
        this.requiredValue = value;
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        if (!base.isAtomicType()) {
            throw new SchemaException("The " + this.getName() + " facet is not available on the non-atomic type " + type.getDescription());
        }
        int primitive = ((AtomicType)base).getPrimitiveType();
        if (primitive != 533 && primitive != 515) {
            throw new SchemaException("The " + this.getName() + " facet is not allowed on a type derived from the type " + base.getDescription());
        }
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        int after;
        int before;
        int dot;
        if (!(value instanceof DecimalValue)) {
            return false;
        }
        String s = value.getStringValue();
        if (s.charAt(0) == '-') {
            s = s.substring(1);
        }
        if ((dot = s.indexOf(46)) < 0) {
            before = s.length();
            if (s.charAt(0) == '0') {
                --before;
            }
            after = 0;
        } else {
            before = dot;
            after = s.length() - before - 1;
            if (s.charAt(0) == '0') {
                --before;
            }
        }
        if (this instanceof TotalDigitsFacet) {
            return before + after <= this.requiredValue;
        }
        return after <= this.requiredValue;
    }

    @Override
    public Function getFacetAsFunctionItem() {
        Callable callable = new Callable(){

            public Sequence<?> call(XPathContext context, Sequence[] arguments) throws XPathException {
                String key;
                switch (key = arguments[0].head().getStringValue()) {
                    case "class": {
                        return new StringValue(DigitsFacet.this.getName());
                    }
                    case "implementation": {
                        return new ObjectValue<DigitsFacet>(DigitsFacet.this);
                    }
                    case "value": {
                        BuiltInAtomicType type = DigitsFacet.this instanceof TotalDigitsFacet ? BuiltInAtomicType.POSITIVE_INTEGER : BuiltInAtomicType.NON_NEGATIVE_INTEGER;
                        return new Int64Value(DigitsFacet.this.requiredValue, type, false);
                    }
                    case "fixed": {
                        return BooleanValue.get(DigitsFacet.this.isFixed());
                    }
                }
                return EmptySequence.getInstance();
            }
        };
        return new CallableFunction(1, callable, SchemaComponent.COMPONENT_FUNCTION_TYPE);
    }
}

