/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserSchemaComponent;
import java.util.Map;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class TypeAlternative
extends SchemaStructure
implements SchemaComponent {
    private XPathExpression condition;
    private String conditionText;
    private NamespaceResolver namespaceContext;
    private String baseURI;
    private String defaultNamespace;
    private Map<StructuredQName, XPathVariable> declaredParams;
    private TypeReference typeReference;

    public TypeAlternative(EnterpriseConfiguration config, XPathExpression condition, String text) {
        this.setConfiguration(config);
        this.condition = condition;
        this.conditionText = text;
    }

    public XPathExpression getCondition() {
        return this.condition;
    }

    public String getConditionText() {
        return this.conditionText;
    }

    public void setDefaultElementNamespace(String namespace) {
        this.defaultNamespace = namespace;
    }

    public String getDefaultElementNamespace() {
        return this.defaultNamespace;
    }

    public void setNamespaceContext(NamespaceResolver resolver) {
        this.namespaceContext = resolver;
    }

    public NamespaceResolver getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setTypeReference(TypeReference type) {
        this.typeReference = type;
    }

    public TypeReference getTypeReference() {
        return this.typeReference;
    }

    public void setParameters(Map<StructuredQName, XPathVariable> parameters) {
        this.declaredParams = parameters;
    }

    public Map<StructuredQName, XPathVariable> getParameters() {
        return this.declaredParams;
    }

    public SchemaType getSchemaType() throws MissingComponentException {
        return (SchemaType)this.typeReference.getTarget();
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        SchemaType type = (SchemaType)PreparedSchema.validateReference(this.typeReference, compiler, false);
        if (type == null) {
            this.setFixupStatus(SchemaComponent.ValidationStatus.INVALID);
            return false;
        }
        return !(type instanceof UserSchemaComponent) || ((UserSchemaComponent)((Object)type)).fixup(compiler);
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("alternativeType");
        serializer.emitNamespaceContext(this.getNamespaceContext());
        serializer.emitAttribute("test", this.conditionText == null ? "true()" : this.conditionText);
        serializer.emitAttribute("type", serializer.getTypeLink((SchemaType)this.typeReference.getTarget()));
        serializer.emitAttribute("defaultNamespace", this.getDefaultElementNamespace());
        serializer.emitAttribute("xml:base", this.getBaseURI());
        serializer.endElement();
    }

    @Override
    public Function getComponentAsFunction() {
        Callable callable = (context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue("Type Alternative");
                }
                case "implementation": {
                    return new ObjectValue<TypeAlternative>(this);
                }
                case "test": {
                    return SchemaStructure.makeXPathExpressionPropertyRecord(this.conditionText, this.namespaceContext, this.baseURI);
                }
                case "type definition": {
                    return this.getTypeReference().getTarget().getComponentAsFunction();
                }
            }
            return EmptySequence.getInstance();
        };
        return new CallableFunction(1, callable, COMPONENT_FUNCTION_TYPE);
    }
}

