/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.AbsorptionFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.StringValueGatherer;
import com.saxonica.ee.stream.om.FleetingDocumentNode;
import com.saxonica.ee.stream.om.FleetingElementNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class SimpleContentFeed
extends AbsorptionFeed {
    public SimpleContentFeed(Feed result) {
        super(result, null);
    }

    @Override
    protected AbsorptionFeed.PendingItem makePendingItem(int sequenceNr, FleetingParentNode node) {
        return new PendingContent(sequenceNr, node);
    }

    @Override
    protected Sequence<?> processGroundedItem(Item item) throws XPathException {
        if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 3) {
            CharSequence cs = item.getStringValueCS();
            if (cs.length() == 0) {
                return EmptySequence.getInstance();
            }
            return item.atomize();
        }
        if (item instanceof AtomicValue) {
            return item;
        }
        if (item instanceof NodeInfo) {
            return item.atomize();
        }
        XPathException xe = new XPathException("Cannot atomize item of type " + Type.displayTypeName(item), "FOTY0013", this.getExpression().getLocation());
        xe.setIsTypeError(true);
        throw xe;
    }

    private static class PendingContent
    extends AbsorptionFeed.PendingItem {
        public FastStringBuffer buffer = new FastStringBuffer(100);
        public FleetingParentNode node;

        public PendingContent(int sequence, FleetingParentNode node) {
            super(sequence);
            this.node = node;
        }

        @Override
        public Receiver getGatherer() {
            return new StringValueGatherer(this.buffer);
        }

        @Override
        public Sequence<?> deliver() throws XPathException {
            if (this.node instanceof FleetingElementNode) {
                FleetingElementNode element = (FleetingElementNode)this.node;
                element.setStringValue(this.buffer);
                return element.atomize();
            }
            FleetingDocumentNode document = (FleetingDocumentNode)this.node;
            document.setStringValue(this.buffer);
            return document.atomize();
        }

        @Override
        public void rollback() {
            this.buffer.setLength(0);
        }
    }
}

