/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.BasicUpdatingExpression;
import com.saxonica.ee.update.PendingUpdateListImpl;
import com.saxonica.ee.update.ReplaceAttributeAction;
import com.saxonica.ee.update.ReplaceNodeAction;
import com.saxonica.ee.validate.SkipValidator;
import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;

public class ReplaceNodeExpression
extends BasicUpdatingExpression {
    private Operand targetOp;
    private Operand replacementOp;
    private int constructionMode;

    public ReplaceNodeExpression(Expression target, Expression replacement, int constructionMode) {
        this.targetOp = new Operand(this, target, OperandRole.INSPECT);
        this.replacementOp = new Operand(this, replacement, OperandRole.SINGLE_ATOMIC);
        this.constructionMode = constructionMode;
    }

    public Expression getTargetExp() {
        return this.targetOp.getChildExpression();
    }

    public void setTargetExp(Expression targetExpression) {
        this.targetOp.setChildExpression(targetExpression);
    }

    public Expression getReplacementExp() {
        return this.replacementOp.getChildExpression();
    }

    public void setReplacementExp(Expression replacement) {
        this.replacementOp.setChildExpression(replacement);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.targetOp, this.replacementOp);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        RoleDiagnostic role0 = new RoleDiagnostic(10, "replace", 0);
        role0.setErrorCode("XUDY0027");
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.NON_EMPTY_SEQUENCE, role0, visitor));
        role0 = new RoleDiagnostic(10, "replace", 0);
        role0.setErrorCode("XUTY0008");
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.OPTIONAL_NODE, role0, visitor));
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ReplaceNodeExpression exp = new ReplaceNodeExpression(this.getTargetExp().copy(rebindings), this.getReplacementExp().copy(rebindings), this.constructionMode);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("replaceNodes", this);
        this.getTargetExp().export(out);
        this.getReplacementExp().export(out);
        out.endElement();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        ArrayList content = new ArrayList();
        NodeInfo target = (NodeInfo)this.getTargetExp().evaluateItem(context);
        if (target == null) {
            XPathException err = new XPathException("Target of replace expression must not be empty", "XUDY0027");
            err.setLocation(this.getLocation());
            throw err;
        }
        int kind = target.getNodeKind();
        if (kind == 13) {
            XPathException err = new XPathException("Target of replace expression must not be a namespace node", "XUTY0008");
            err.setLocation(this.getLocation());
            throw err;
        }
        if (kind == 9) {
            XPathException err = new XPathException("Target of replace expression must not be a document node", "XUTY0008");
            err.setLocation(this.getLocation());
            throw err;
        }
        NodeInfo parent = target.getParent();
        if (parent == null) {
            XPathException err = new XPathException("Target node of replace expression has no parent", "XUDY0009");
            err.setLocation(this.getLocation());
            throw err;
        }
        if (!(parent instanceof MutableNodeInfo)) {
            XPathException err = new XPathException("Target node of replace expression is not updateable", "SXUP0081");
            err.setLocation(this.getLocation());
            throw err;
        }
        if (kind == 2) {
            Object item;
            SequenceIterator<?> iter = this.getReplacementExp().iterate(context);
            AttributeCollectionImpl atts = new AttributeCollectionImpl(context.getConfiguration());
            while ((item = iter.next()) != null) {
                SimpleType attributeType;
                boolean isAttribute;
                boolean bl = isAttribute = item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 2;
                if (!isAttribute) {
                    XPathException err = new XPathException("The replacement nodes for an attribute must all be attributes", "XUTY0011");
                    err.setLocation(this.getLocation());
                    throw err;
                }
                NodeInfo att = (NodeInfo)item;
                int properties = 0;
                if (this.constructionMode == 4 || Untyped.getInstance().equals(parent.getSchemaType())) {
                    attributeType = BuiltInAtomicType.UNTYPED_ATOMIC;
                } else {
                    attributeType = (SimpleType)att.getSchemaType();
                    if (att.isId() || att.getLocalPart().equals("id") && att.getURI().equals("http://www.w3.org/XML/1998/namespace")) {
                        properties |= 0x800;
                    }
                    if (att.isIdref()) {
                        properties |= 0x1000;
                    }
                }
                atts.addAttribute(NameOfNode.makeName(att), attributeType, att.getStringValue(), ExplicitLocation.UNKNOWN_LOCATION, properties);
            }
            ReplaceAttributeAction action = new ReplaceAttributeAction(parent, target, atts);
            action.setOriginator(this);
            ((PendingUpdateListImpl)pul).add(action);
        } else {
            Object item;
            SequenceIterator<?> iter = this.getReplacementExp().iterate(context);
            while ((item = iter.next()) != null) {
                if (item instanceof NodeInfo && ((NodeInfo)item).getNodeKind() == 2) {
                    XPathException err = new XPathException("An attribute node cannot replace a node that is not itself an attribute", "XUTY0010");
                    err.setLocation(this.getLocation());
                    throw err;
                }
                content.add(item);
            }
            if (content.isEmpty()) {
                try {
                    ReplaceNodeAction action = new ReplaceNodeAction(new NodeImpl[0], (MutableNodeInfo)target);
                    action.setOriginator(this);
                    ((PendingUpdateListImpl)pul).add(action);
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this.getLocation());
                    e.maybeSetContext(context);
                    throw e;
                }
            }
            Builder builder = ((MutableNodeInfo)parent).newBuilder();
            Controller controller = context.getController();
            builder.setLineNumbering(controller.getConfiguration().isLineNumbering());
            PipelineConfiguration pipe = controller.makePipelineConfiguration();
            pipe.setXPathContext(context);
            pipe.setHostLanguage(this.getPackageData().getHostLanguage());
            builder.setPipelineConfiguration(pipe);
            Receiver r = builder;
            if (this.constructionMode == 4 || Untyped.getInstance().equals(parent.getSchemaType())) {
                r = new SkipValidator(r);
            }
            TreeReceiver out = new TreeReceiver(r);
            out.setPipelineConfiguration(pipe);
            out.open();
            out.startDocument(0);
            for (Object aContent : content) {
                Item n = (Item)aContent;
                out.append(n, ExplicitLocation.UNKNOWN_LOCATION, 524288);
            }
            out.endDocument();
            out.close();
            NodeInfo root = builder.getCurrentRoot();
            AxisIterator top = root.iterateAxis((byte)3);
            SequenceExtent<NodeInfo> extent = new SequenceExtent<NodeInfo>(top);
            int len = extent.getLength();
            NodeInfo[] array = new NodeInfo[len];
            for (int i = 0; i < len; ++i) {
                array[i] = extent.itemAt(i);
            }
            try {
                ReplaceNodeAction action = new ReplaceNodeAction(array, (MutableNodeInfo)target);
                action.setOriginator(this);
                ((PendingUpdateListImpl)pul).add(action);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.getLocation());
                e.maybeSetContext(context);
                throw e;
            }
        }
    }

    @Override
    public String getExpressionName() {
        return "replaceNode";
    }
}

