/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.util;

import com.saxonica.ee.bytecode.AdjacentTextNodeMergerCompiler;
import com.saxonica.ee.bytecode.AnalyzeStringCompiler;
import com.saxonica.ee.bytecode.AndExpressionCompiler;
import com.saxonica.ee.bytecode.ApplyImportsCompiler;
import com.saxonica.ee.bytecode.ApplyTemplatesCompiler;
import com.saxonica.ee.bytecode.ArithmeticCompiler;
import com.saxonica.ee.bytecode.AtomicSequenceConverterCompiler;
import com.saxonica.ee.bytecode.AtomizerCompiler;
import com.saxonica.ee.bytecode.AttributeGetterCompiler;
import com.saxonica.ee.bytecode.AxisExpressionCompiler;
import com.saxonica.ee.bytecode.BlockCompiler;
import com.saxonica.ee.bytecode.BreakInstrCompiler;
import com.saxonica.ee.bytecode.ByteCodeCandidate;
import com.saxonica.ee.bytecode.CallTemplateCompiler;
import com.saxonica.ee.bytecode.CallableExpressionCompiler;
import com.saxonica.ee.bytecode.CardinalityCheckerCompiler;
import com.saxonica.ee.bytecode.CastExpressionCompiler;
import com.saxonica.ee.bytecode.CastableExpressionCompiler;
import com.saxonica.ee.bytecode.ChooseCompiler;
import com.saxonica.ee.bytecode.CommentCompiler;
import com.saxonica.ee.bytecode.CompareToIntegerConstantCompiler;
import com.saxonica.ee.bytecode.CompiledExpression;
import com.saxonica.ee.bytecode.CompiledExpressionCompiler;
import com.saxonica.ee.bytecode.ComputedAttributeCompiler;
import com.saxonica.ee.bytecode.ComputedElementCompiler;
import com.saxonica.ee.bytecode.ConditionalSorterCompiler;
import com.saxonica.ee.bytecode.ContextItemCompiler;
import com.saxonica.ee.bytecode.CopyCompiler;
import com.saxonica.ee.bytecode.DocumentInstrCompiler;
import com.saxonica.ee.bytecode.DocumentSorterCompiler;
import com.saxonica.ee.bytecode.EmptyTextNodeRemoverCompiler;
import com.saxonica.ee.bytecode.EquivalenceComparisonCompiler;
import com.saxonica.ee.bytecode.ErrorExpressionCompiler;
import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.FLWORExpressionCompiler;
import com.saxonica.ee.bytecode.FilterExpressionCompiler;
import com.saxonica.ee.bytecode.FirstItemExpressionCompiler;
import com.saxonica.ee.bytecode.FixedAttributeCompiler;
import com.saxonica.ee.bytecode.FixedElementCompiler;
import com.saxonica.ee.bytecode.ForEachGroupCompiler;
import com.saxonica.ee.bytecode.ForExpressionCompiler;
import com.saxonica.ee.bytecode.FunctionLiteralCompiler;
import com.saxonica.ee.bytecode.FunctionSequenceCoercerCompiler;
import com.saxonica.ee.bytecode.GeneralComparisonCompiler;
import com.saxonica.ee.bytecode.HomogeneityCheckerCompiler;
import com.saxonica.ee.bytecode.IdentityComparisonCompiler;
import com.saxonica.ee.bytecode.IndexedFilterExpressionCompiler;
import com.saxonica.ee.bytecode.InstanceOfCompiler;
import com.saxonica.ee.bytecode.IntegerRangeTestCompiler;
import com.saxonica.ee.bytecode.InterpretedExpressionCompiler;
import com.saxonica.ee.bytecode.IsLastExpressionCompiler;
import com.saxonica.ee.bytecode.ItemCheckerCompiler;
import com.saxonica.ee.bytecode.IterateInstrCompiler;
import com.saxonica.ee.bytecode.JavaExtensionFunctionCallCompiler;
import com.saxonica.ee.bytecode.LastItemExpressionCompiler;
import com.saxonica.ee.bytecode.LetExpressionCompiler;
import com.saxonica.ee.bytecode.LiteralCompiler;
import com.saxonica.ee.bytecode.LocalParamBlockCompiler;
import com.saxonica.ee.bytecode.LocalParamCompiler;
import com.saxonica.ee.bytecode.LocalVariableReferenceCompiler;
import com.saxonica.ee.bytecode.NamespaceConstructorCompiler;
import com.saxonica.ee.bytecode.NegateExpressionCompiler;
import com.saxonica.ee.bytecode.NextIterationCompiler;
import com.saxonica.ee.bytecode.NextMatchCompiler;
import com.saxonica.ee.bytecode.OrExpressionCompiler;
import com.saxonica.ee.bytecode.OuterForExpressionCompiler;
import com.saxonica.ee.bytecode.PartialApplyCompiler;
import com.saxonica.ee.bytecode.ProcessingInstructionCompiler;
import com.saxonica.ee.bytecode.QuantifiedExpressionCompiler;
import com.saxonica.ee.bytecode.RangeExpressionCompiler;
import com.saxonica.ee.bytecode.ResultDocumentCompiler;
import com.saxonica.ee.bytecode.RootExpressionCompiler;
import com.saxonica.ee.bytecode.SimpleStepExpressionCompiler;
import com.saxonica.ee.bytecode.SingletonAtomizerCompiler;
import com.saxonica.ee.bytecode.SingletonIntersectExpressionCompiler;
import com.saxonica.ee.bytecode.SlashExpressionCompiler;
import com.saxonica.ee.bytecode.SortExpressionCompiler;
import com.saxonica.ee.bytecode.SquareArrayConstructorCompiler;
import com.saxonica.ee.bytecode.StaticFunctionCallCompiler;
import com.saxonica.ee.bytecode.SubscriptExpressionCompiler;
import com.saxonica.ee.bytecode.SuppliedParameterReferenceCompiler;
import com.saxonica.ee.bytecode.SwitchExpressionCompiler;
import com.saxonica.ee.bytecode.TailCallLoopCompiler;
import com.saxonica.ee.bytecode.TailExpressionCompiler;
import com.saxonica.ee.bytecode.TraceExpressionCompiler;
import com.saxonica.ee.bytecode.UseAttributeSetCompiler;
import com.saxonica.ee.bytecode.UserFunctionCallCompiler;
import com.saxonica.ee.bytecode.ValueComparisonCompiler;
import com.saxonica.ee.bytecode.ValueOfCompiler;
import com.saxonica.ee.bytecode.VariableReferenceCompiler;
import com.saxonica.ee.bytecode.VennExpressionCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import java.util.HashMap;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.instruct.IterateInstr;
import net.sf.saxon.expr.parser.ICompilerService;
import net.sf.saxon.functions.ContextItemAccessorFunction;

public class ExpressionCompilerMap {
    private static HashMap<String, ExpressionCompiler> map = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExpressionCompiler getExpressionCompiler(Expression expr, ICompilerService compiler) throws CannotCompileException {
        String expressionName;
        ExpressionCompiler ec;
        if (expr instanceof ByteCodeCandidate) {
            expr = ((ByteCodeCandidate)expr).getBaseExpression();
        }
        if (expr instanceof SystemFunctionCall) {
            SystemFunctionCall fc = (SystemFunctionCall)expr;
            String compilerName = fc.getTargetFunction().getCompilerName();
            if (compilerName != null) return ((CompilerService)compiler).getNamedExpressionCompiler(compilerName);
            if (fc.getTargetFunction() instanceof ContextItemAccessorFunction) {
                Expression exp = ((ContextItemAccessorFunction)fc.getTargetFunction()).makeContextItemExplicit();
                return ExpressionCompilerMap.getExpressionCompiler(exp, compiler);
            }
        } else {
            if (expr instanceof CompiledExpression) {
                return new CompiledExpressionCompiler();
            }
            if (expr instanceof IterateInstr) {
                if (!((IterateInstr)expr).isCompilable()) return new InterpretedExpressionCompiler();
                return new IterateInstrCompiler();
            }
        }
        if ((ec = map.get(expressionName = expr.getExpressionName())) != null) return ec;
        if (!(expr instanceof Callable)) return new InterpretedExpressionCompiler();
        return new CallableExpressionCompiler();
    }

    static {
        map.put("mergeAdj", new AdjacentTextNodeMergerCompiler());
        map.put("analyzeString", new AnalyzeStringCompiler());
        map.put("and-expression", new AndExpressionCompiler());
        map.put("xsl:apply-imports", new ApplyImportsCompiler());
        map.put("xsl:apply-templates", new ApplyTemplatesCompiler());
        map.put("arithmetic", new ArithmeticCompiler());
        map.put("attGetter", new AttributeGetterCompiler());
        map.put("convert", new AtomicSequenceConverterCompiler());
        map.put("data", new AtomizerCompiler());
        map.put("axisStep", new AxisExpressionCompiler());
        map.put("sequence", new BlockCompiler());
        map.put("xsl:break", new BreakInstrCompiler());
        map.put("xsl:call-template", new CallTemplateCompiler());
        map.put("CheckCardinality", new CardinalityCheckerCompiler());
        map.put("cast", new CastExpressionCompiler());
        map.put("castable", new CastableExpressionCompiler());
        map.put("choose", new ChooseCompiler());
        map.put("xsl:comment", new CommentCompiler());
        map.put("compareToInt", new CompareToIntegerConstantCompiler());
        map.put("xsl:attribute", new ComputedAttributeCompiler());
        map.put("xsl:element", new ComputedElementCompiler());
        map.put("conditionalSort", new ConditionalSorterCompiler());
        map.put("consume", new SuppliedParameterReferenceCompiler());
        map.put("convertUntyped", new AtomicSequenceConverterCompiler());
        map.put("dot", new ContextItemCompiler());
        map.put("xsl:copy", new CopyCompiler());
        map.put("xsl:document", new DocumentInstrCompiler());
        map.put("docOrder", new DocumentSorterCompiler());
        map.put("emptyTextNodeRemover", new EmptyTextNodeRemoverCompiler());
        map.put("equivalent", new EquivalenceComparisonCompiler());
        map.put("errorExpr", new ErrorExpressionCompiler());
        map.put("FLWOR", new FLWORExpressionCompiler());
        map.put("filter", new FilterExpressionCompiler());
        map.put("first", new FirstItemExpressionCompiler());
        map.put("att", new FixedAttributeCompiler());
        map.put("element", new FixedElementCompiler());
        map.put("forEach", new SlashExpressionCompiler());
        map.put("xsl:for-each-group", new ForEachGroupCompiler());
        map.put("for", new ForExpressionCompiler());
        map.put("namedFunctionRef", new FunctionLiteralCompiler());
        map.put("fnCoercer", new FunctionSequenceCoercerCompiler());
        map.put("GeneralComparison", new GeneralComparisonCompiler());
        map.put("homCheck", new HomogeneityCheckerCompiler());
        map.put("nodeComparison", new IdentityComparisonCompiler());
        map.put("indexedFilter", new IndexedFilterExpressionCompiler());
        map.put("instance", new InstanceOfCompiler());
        map.put("intRangeTest", new IntegerRangeTestCompiler());
        map.put("isLast", new IsLastExpressionCompiler());
        map.put("treatAs", new ItemCheckerCompiler());
        map.put("xsl:iterate", new IterateInstrCompiler());
        map.put("javaCall", new JavaExtensionFunctionCallCompiler());
        map.put("lastOf", new LastItemExpressionCompiler());
        map.put("let", new LetExpressionCompiler());
        map.put("literal", new LiteralCompiler());
        map.put("param", new LocalParamCompiler());
        map.put("params", new LocalParamBlockCompiler());
        map.put("locVarRef", new LocalVariableReferenceCompiler());
        map.put("xsl:namespace", new NamespaceConstructorCompiler());
        map.put("minus", new NegateExpressionCompiler());
        map.put("xsl:next-iteration", new NextIterationCompiler());
        map.put("xsl:next-match", new NextMatchCompiler());
        map.put("or-expression", new OrExpressionCompiler());
        map.put("outerFor", new OuterForExpressionCompiler());
        map.put("partialApply", new PartialApplyCompiler());
        map.put("xsl:processing-instruction", new ProcessingInstructionCompiler());
        map.put("some", new QuantifiedExpressionCompiler());
        map.put("every", new QuantifiedExpressionCompiler());
        map.put("range", new RangeExpressionCompiler());
        map.put("xsl:result-document", new ResultDocumentCompiler());
        map.put("root", new RootExpressionCompiler());
        map.put("simpleStep", new SimpleStepExpressionCompiler());
        map.put("atomizeSingleton", new SingletonAtomizerCompiler());
        map.put("pathExpression", new SlashExpressionCompiler());
        map.put("sort", new SortExpressionCompiler());
        map.put("SquareArrayConstructor", new SquareArrayConstructorCompiler());
        map.put("staticFunctionCall", new StaticFunctionCallCompiler());
        map.put("subscript", new SubscriptExpressionCompiler());
        map.put("supplied", new SuppliedParameterReferenceCompiler());
        map.put("switch", new SwitchExpressionCompiler());
        map.put("sysFuncCall", null);
        map.put("tailCallLoop", new TailCallLoopCompiler());
        map.put("tail", new TailExpressionCompiler());
        map.put("trace", new TraceExpressionCompiler());
        map.put("useAS", new UseAttributeSetCompiler());
        map.put("userFunctionCall", new UserFunctionCallCompiler());
        map.put("ValueComparison", new ValueComparisonCompiler());
        map.put("xsl:text", new ValueOfCompiler());
        map.put("xsl:value-of", new ValueOfCompiler());
        map.put("xsl:number", new ValueOfCompiler());
        map.put("varRef", new VariableReferenceCompiler());
        map.put("union", new VennExpressionCompiler());
        map.put("intersect", new VennExpressionCompiler());
        map.put("singleton-intersect", new SingletonIntersectExpressionCompiler());
        map.put("except", new VennExpressionCompiler());
    }
}

