/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.DistanceConstraint;
import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.SpanElementQuery;
import de.ids_mannheim.korap.query.spans.DistanceExclusionSpans;
import de.ids_mannheim.korap.query.spans.ElementDistanceExclusionSpans;
import de.ids_mannheim.korap.query.spans.ElementDistanceSpans;
import de.ids_mannheim.korap.query.spans.TokenDistanceSpans;
import de.ids_mannheim.korap.query.spans.UnorderedElementDistanceSpans;
import de.ids_mannheim.korap.query.spans.UnorderedTokenDistanceSpans;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class SpanDistanceQuery
extends SimpleSpanQuery {
    private boolean exclusion;
    private boolean isOrdered;
    private int minDistance;
    private int maxDistance;
    private SpanElementQuery elementQuery;
    private String distanceUnit;
    private String spanName;
    private DistanceConstraint constraint;

    public SpanDistanceQuery(SpanQuery firstClause, SpanQuery secondClause, DistanceConstraint constraint, boolean collectPayloads) {
        super(firstClause, secondClause, collectPayloads);
        if (constraint == null) {
            throw new IllegalArgumentException("Distance constraint cannot be null.");
        }
        this.constraint = constraint;
        this.minDistance = constraint.getMinDistance();
        this.maxDistance = constraint.getMaxDistance();
        this.isOrdered = constraint.isOrdered();
        this.exclusion = constraint.isExclusion();
        this.distanceUnit = constraint.getUnit();
        if (constraint.getElementQuery() != null) {
            this.spanName = "spanElementDistance";
            this.elementQuery = constraint.getElementQuery();
        } else {
            this.spanName = "spanDistance";
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.spanName);
        sb.append("(");
        sb.append(this.firstClause.toString(field));
        sb.append(", ");
        sb.append(this.secondClause.toString(field));
        sb.append(", ");
        sb.append("[(");
        sb.append(this.distanceUnit);
        sb.append("[");
        sb.append(this.minDistance);
        sb.append(":");
        sb.append(this.maxDistance);
        sb.append("], ");
        sb.append(this.isOrdered ? "ordered, " : "notOrdered, ");
        sb.append(this.exclusion ? "excluded)])" : "notExcluded)])");
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public SpanDistanceQuery clone() {
        SpanDistanceQuery spanDistanceQuery = new SpanDistanceQuery((SpanQuery)this.firstClause.clone(), (SpanQuery)this.secondClause.clone(), this.constraint, this.collectPayloads);
        if (this.elementQuery != null) {
            spanDistanceQuery.setElementQuery(this.elementQuery);
        }
        spanDistanceQuery.setBoost(this.getBoost());
        return spanDistanceQuery;
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        if (this.elementQuery != null) {
            if (this.isExclusion()) {
                return new ElementDistanceExclusionSpans(this, context, acceptDocs, termContexts);
            }
            if (this.isOrdered) {
                return new ElementDistanceSpans(this, context, acceptDocs, termContexts);
            }
            return new UnorderedElementDistanceSpans(this, context, acceptDocs, termContexts);
        }
        if (this.isExclusion()) {
            return new DistanceExclusionSpans(this, context, acceptDocs, termContexts);
        }
        if (this.isOrdered) {
            return new TokenDistanceSpans(this, context, acceptDocs, termContexts);
        }
        return new UnorderedTokenDistanceSpans(this, context, acceptDocs, termContexts);
    }

    public int getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(int minDistance) {
        this.minDistance = minDistance;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(int maxDistance) {
        this.maxDistance = maxDistance;
    }

    public SpanElementQuery getElementQuery() {
        return this.elementQuery;
    }

    public void setElementQuery(SpanElementQuery elementQuery) {
        this.elementQuery = elementQuery;
    }

    public boolean isExclusion() {
        return this.exclusion;
    }

    public void setExclusion(boolean exclusion) {
        this.exclusion = exclusion;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public void setOrder(boolean isOrdered) {
        this.isOrdered = isOrdered;
    }
}

