/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.converter;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.converter.ConverterCompiler;
import com.saxonica.ee.bytecode.util.Callback;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.MessageTemplate;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class StringToBooleanCompiler
extends ConverterCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        AtomicType targetType = cast.getTargetType();
        Converter converter = cast.getConverter();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        AtomicType sourceType = (AtomicType)base.getItemType();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        ExpressionCompiler.visitAnnotation(compiler, "StringToBooleanConverter-Item");
        if (allowsEmpty) {
            LabelInfo empty = methodInfo.newLabel("returnEmpty");
            LabelInfo end = methodInfo.newLabel("end");
            this.compileToPrimitive(compiler, expression, Boolean.TYPE, new OnEmpty.UnwindAndJump(empty));
            ga.invokeStaticMethod(BooleanValue.class, "get", Boolean.TYPE);
            ga.goTo(end);
            methodInfo.placeLabel(empty);
            ga.pushNull();
            methodInfo.placeLabel(end);
        } else {
            this.compileToPrimitive(compiler, expression, Integer.TYPE, OnEmpty.RETURN_NULL);
            ga.invokeStaticMethod(BooleanValue.class, "get", Boolean.TYPE);
        }
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        AtomicType targetType = cast.getTargetType();
        Converter converter = cast.getConverter();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        AtomicType sourceType = (AtomicType)base.getItemType();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        ExpressionCompiler.visitAnnotation(compiler, "StringToBooleanConverter-Primitive");
        if (allowsEmpty && !(onEmpty instanceof OnEmpty.UnwindAndJump)) {
            throw new IllegalArgumentException();
        }
        LabelInfo notEmpty = methodInfo.newLabel("notEmpty_cast");
        LabelInfo end = methodInfo.newLabel("castEnd");
        compiler.compileToPrimitive(base, CharSequence.class, onEmpty);
        int strVar = ga.newLocal(CharSequence.class);
        ga.storeLocal(strVar);
        ga.loadLocal(strVar);
        ga.invokeStaticMethod(Callback.class, "booleanFromString", CharSequence.class);
        ga.dup();
        ga.ifZCmp(156, end.label());
        ga.pop();
        compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Cannot cast string to boolean: {$1}", strVar), "FORG0001", cast.getLocation(), false);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(strVar);
    }
}

