/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.ChoiceModelGroup;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ElementParticle;
import com.saxonica.ee.schema.ElementWildcard;
import com.saxonica.ee.schema.ModelGroup;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.ModelGroupParticle;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SequenceModelGroup;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.Wildcard;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntToIntArrayMap;
import net.sf.saxon.z.IntToIntHashMap;
import net.sf.saxon.z.IntToIntMap;

public class AllModelGroup
extends ModelGroup {
    private int[] minima;
    private int[] maxima;
    private StructuredQName[] elementNames;
    private int numberOfElementParticles = 0;
    private IntToIntMap counterMap;
    private IntHashMap<ElementDecl> declarationMap;
    private List<ElementWildcard> wildcards;

    @Override
    public void addParticle(Particle particle) {
        super.addParticle(particle);
        if (particle instanceof ElementWildcard) {
            if (this.wildcards == null) {
                this.wildcards = new ArrayList<ElementWildcard>(4);
            }
            this.wildcards.add((ElementWildcard)particle);
        } else {
            ++this.numberOfElementParticles;
        }
    }

    public int getNumberOfElementParticles() {
        return this.numberOfElementParticles;
    }

    @Override
    public boolean containsAll(boolean simplified) {
        return true;
    }

    @Override
    public boolean isEmptiable() throws MissingComponentException {
        for (Particle aContentModel : this.contentModel) {
            if (aContentModel.isEmptiable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPointless(ModelGroup container) {
        return false;
    }

    @Override
    protected boolean checkElements(IntHashMap<ElementDecl> map, SchemaCompiler compiler) throws SchemaException, MissingComponentException {
        if (map.size() > 0) {
            compiler.error("<xs:all> cannot appear within the content model of another compositor", this);
            return false;
        }
        for (Particle p : this.getSimplifiedContentModel()) {
            if (!(p instanceof ElementParticle)) continue;
            ElementParticle ep = (ElementParticle)p;
            int key = ((ElementDecl)ep.getTarget()).getFingerprint();
            ElementDecl prev = map.get(key);
            if (prev == null) {
                map.put(key, ep.getDeclaration());
                continue;
            }
            String err = "Two elements with the same name " + Err.wrap(ep.getName(), 1) + " appear in the content model of <xs:all>. This violates the Unique Particle Attribution constraint.";
            compiler.error(err, this);
            return false;
        }
        IntHashMap<ElementDecl> implicitMembers = new IntHashMap<ElementDecl>(20);
        Iterator<ElementDecl> iterM = map.valueIterator();
        while (iterM.hasNext()) {
            ElementDecl e = iterM.next();
            if (!e.isGlobal()) continue;
            for (ElementDecl member : e.getSubstitutionGroupMembers()) {
                ElementDecl existing = implicitMembers.put(member.getFingerprint(), e);
                if (existing == null) continue;
                String err = "An element " + Err.wrap(member.getDisplayName(), 1) + " appears implicitly in the expansion of more than one particle of the xs:all group, because it is a member of the substitution groups of both element " + Err.wrap(existing.getDisplayName(), 1) + " and element " + Err.wrap(e.getDisplayName(), 1) + ". This violates the Unique Particle Attribution constraint.";
                compiler.error(err, this);
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
        }
        if (this.wildcards != null) {
            for (int i = 0; i < this.wildcards.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    if (!this.wildcards.get(j).getWildcard().overlaps(this.wildcards.get(i).getWildcard())) continue;
                    String err = "The <xs:all> content model contains two <xs:any> wildcards that overlap each other (there are elements that could match either wildcard). This violates the Unique Particle Attribution Constraint.";
                    compiler.error(err, this);
                    this.setValidationStatus(SchemaValidationStatus.INVALID);
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public String getCompositorName() {
        return "all";
    }

    @Override
    public List<Particle> getSimplifiedContentModel() throws MissingComponentException {
        if (this.simplifiedContentModel == null) {
            List<Particle> s1 = super.getSimplifiedContentModel();
            ArrayList<Particle> s2 = new ArrayList<Particle>();
            for (Particle p : s1) {
                if (p instanceof ModelGroupParticle) {
                    ModelGroup mg = (ModelGroup)p.getTarget();
                    for (Particle q : mg.getSimplifiedContentModel()) {
                        s2.add(q);
                    }
                    continue;
                }
                s2.add(p);
            }
            this.simplifiedContentModel = s2;
        }
        return this.simplifiedContentModel;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        if (!super.validate(compiler)) {
            return false;
        }
        for (Particle structure : this.getParticles()) {
            if (structure instanceof ModelGroupParticle) {
                ModelGroupParticle mgp;
                ModelGroupDefinition def;
                List<Particle> groupContents;
                ModelGroupParticle ref = (ModelGroupParticle)structure;
                if (!ref.isResolved()) continue;
                boolean ok = false;
                if (ref.getMinOccurs() == 1 && ref.getMaxOccurs() == 1 && (groupContents = (def = (ModelGroupDefinition)ref.getGroup()).getParticles()).size() == 1 && groupContents.get(0) instanceof ModelGroupParticle && (mgp = (ModelGroupParticle)groupContents.get(0)).getMinOccurs() == 1 && mgp.getMaxOccurs() == 1 && mgp.getTarget() instanceof AllModelGroup) {
                    ok = true;
                }
                if (ok) continue;
                String err = "Group " + ref.getTargetComponentName().getDisplayName() + " is referenced in an xs:all group, so it must itself contain an xs:all group with minOccurs = maxOccurs = 1";
                compiler.error(err, ref);
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return false;
            }
            structure.validate(compiler);
        }
        this.elaborate(compiler);
        return true;
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        List<Particle> particles = this.getSimplifiedContentModel();
        int len = particles.size();
        this.minima = new int[len];
        this.maxima = new int[len];
        this.elementNames = new StructuredQName[len];
        this.counterMap = particles.size() < 8 ? new IntToIntArrayMap(particles.size() + 1) : new IntToIntHashMap(particles.size() + 1);
        this.declarationMap = new IntHashMap(particles.size() + 1);
        int wildcardIndex = 0;
        int elementIndex = this.wildcards == null ? 0 : this.wildcards.size();
        for (Particle particle : particles) {
            if (particle instanceof ElementParticle) {
                this.minima[elementIndex] = particle.getMinOccurs();
                this.maxima[elementIndex] = particle.getMaxOccurs();
                ElementDecl decl = ((ElementParticle)particle).getDeclaration();
                int key = decl.getFingerprint();
                this.elementNames[elementIndex] = particle.getTargetComponentName();
                this.counterMap.put(key, elementIndex);
                this.declarationMap.put(key, decl);
                Collection<ElementDecl> group = decl.getSubstitutionGroupMembers();
                for (ElementDecl substituteDecl : group) {
                    int fp = substituteDecl.getFingerprint();
                    this.counterMap.put(fp, elementIndex);
                    this.declarationMap.put(fp, substituteDecl);
                }
                ++elementIndex;
                continue;
            }
            this.minima[wildcardIndex] = particle.getMinOccurs();
            this.maxima[wildcardIndex] = particle.getMaxOccurs();
            ++wildcardIndex;
        }
    }

    public int[] getMaxima() {
        return this.maxima;
    }

    public int[] getMinima() {
        return this.minima;
    }

    public StructuredQName[] getNameCodes() {
        return this.elementNames;
    }

    public IntToIntMap getCounterMap() {
        return this.counterMap;
    }

    public IntHashMap<ElementDecl> getDeclarationMap() {
        return this.declarationMap;
    }

    public List<ElementWildcard> getWildcards() {
        if (this.wildcards == null) {
            return Collections.emptyList();
        }
        return this.wildcards;
    }

    protected static String allSubsumes(UserComplexType base, ComplexType sub, SchemaCompiler compiler) throws SchemaException {
        ModelGroupParticle all = base.getAllCompositor();
        if (sub instanceof UserComplexType) {
            Particle subp = ((UserComplexType)sub).makeExtendedParticle(compiler);
            return AllModelGroup.subsumesParticle(all, subp, compiler);
        }
        return "Type " + sub.getDescription() + " is not a valid restriction of a type defined using <xs:all>";
    }

    private static String subsumesParticle(ModelGroupParticle all, Particle subp, SchemaCompiler compiler) throws MissingComponentException {
        while (subp instanceof ModelGroupParticle && subp.getMinOccurs() == 1 && subp.getMaxOccurs() == 1 && ((ModelGroupParticle)subp).getGroup().getSimplifiedContentModel().size() == 1) {
            subp = ((ModelGroupParticle)subp).getGroup().getSimplifiedContentModel().get(0);
        }
        if (subp instanceof ElementParticle || subp instanceof ElementWildcard) {
            SequenceModelGroup group = new SequenceModelGroup();
            group.addParticle(subp);
            return ((AllModelGroup)all.getGroup()).subsumesAllOrSequence(group, compiler);
        }
        if (subp instanceof ModelGroupParticle) {
            ModelGroup subg = ((ModelGroupParticle)subp).getGroup();
            if (all.getMinOccurs() > subp.getMinOccurs()) {
                return "The derived type has a lower minOccurs (" + subp.getMinOccurs() + ") than the base type (" + all.getMinOccurs() + ")";
            }
            if (all.getMaxOccurs() > 0 && all.getMaxOccurs() < subp.getMaxOccurs()) {
                return "The derived type has a greater maxOccurs (" + subp.getMaxOccurs() + ") than the base type (" + all.getMaxOccurs() + ")";
            }
            if (subg instanceof AllModelGroup || subg instanceof SequenceModelGroup || subg instanceof ModelGroupDefinition) {
                return ((AllModelGroup)all.getGroup()).subsumesAllOrSequence(subg, compiler);
            }
            if (subg instanceof ChoiceModelGroup) {
                ChoiceModelGroup choice = (ChoiceModelGroup)subg;
                int branchNr = 1;
                for (Particle branch : choice.getParticles()) {
                    String result = AllModelGroup.subsumesParticle(all, branch, compiler);
                    if (result != null) {
                        return (branchNr == 1 ? "The first branch" : "Branch " + branchNr) + " of the choice is not a valid restriction of the content model of the base type. " + result;
                    }
                    ++branchNr;
                }
                return null;
            }
            throw new AssertionError((Object)("Unknown class of ModelGroup " + subg.getClass().getName()));
        }
        throw new AssertionError((Object)("Unknown class of particle " + subp.getClass().getName()));
    }

    private String subsumesAllOrSequence(ModelGroup subg, SchemaCompiler compiler) throws MissingComponentException {
        int i;
        List<Particle> baseParticles = this.getSimplifiedContentModel();
        IntHashMap<ElementParticle> baseElements = new IntHashMap<ElementParticle>(baseParticles.size());
        int[] minCounters = new int[this.getMinima().length];
        int[] maxCounters = new int[this.getMaxima().length];
        ElementParticle[] baseParticleArray = new ElementParticle[this.getMinima().length];
        for (Particle p : baseParticles) {
            if (!(p instanceof ElementParticle)) continue;
            int fp = ((ElementParticle)p).getDeclaration().getFingerprint();
            baseElements.put(fp, (ElementParticle)p);
            baseParticleArray[this.counterMap.get((int)fp)] = (ElementParticle)p;
        }
        List<Particle> derivedParticles = subg.getSimplifiedContentModel();
        derivedParticles = this.flattenParticleList(derivedParticles, 1, 1);
        for (i = 0; i < derivedParticles.size(); ++i) {
            int counterIndex;
            if (derivedParticles.get(i) instanceof ElementParticle) {
                ElementParticle baseParticle;
                ElementDecl baseElement;
                String err;
                String clarkName;
                ElementParticle derivedElement = (ElementParticle)derivedParticles.get(i);
                int derivedfp = derivedElement.getDeclaration().getFingerprint();
                counterIndex = this.counterMap.get(derivedfp);
                if (counterIndex == this.counterMap.getDefaultValue()) {
                    clarkName = derivedElement.getDisplayName();
                    return "The derived type allows element " + Err.wrap(clarkName, 1) + " but the base type does not";
                }
                int n = counterIndex;
                minCounters[n] = minCounters[n] + derivedElement.getMinOccurs();
                if (derivedElement.getMaxOccurs() == -1) {
                    if (this.getMaxima()[counterIndex] != -1) {
                        clarkName = derivedElement.getDisplayName();
                        return "The derived type allows unlimited occurrences of element " + Err.wrap(clarkName, 1) + " but the base type does not";
                    }
                } else {
                    int n2 = counterIndex;
                    maxCounters[n2] = maxCounters[n2] + derivedElement.getMaxOccurs();
                    int baseMax = this.getMaxima()[counterIndex];
                    if (baseMax != -1 && maxCounters[counterIndex] > baseMax) {
                        String clarkName2 = derivedElement.getDisplayName();
                        return "The derived type allows more occurrences (" + maxCounters[counterIndex] + ") of element " + Err.wrap(clarkName2, 1) + " than the base type allows (" + baseMax + ")";
                    }
                }
                if ((err = UserComplexType.elementParticleMatches(baseElement = (baseParticle = baseParticleArray[counterIndex]).getDeclaration(), derivedElement.getDeclaration(), compiler)) != null) {
                    return err;
                }
                try {
                    derivedElement.getDeclaration().getType().checkTypeDerivationIsOK(baseElement.getType(), baseElement.getType().getBlock());
                    continue;
                }
                catch (SchemaException err2) {
                    String clarkName3 = derivedElement.getDisplayName();
                    return "The type of element " + Err.wrap(clarkName3, 1) + " in the derived type is not validly derived from the type of the corresponding element in the base type";
                }
            }
            if (derivedParticles.get(i) instanceof ElementWildcard) {
                ElementWildcard wp = (ElementWildcard)derivedParticles.get(i);
                Wildcard w = wp.getWildcard();
                counterIndex = 0;
                Wildcard union = null;
                int unionMax = 0;
                for (Particle baseParticle : baseParticles) {
                    if (baseParticle instanceof ElementWildcard) {
                        ElementWildcard vp = (ElementWildcard)baseParticle;
                        Wildcard v = vp.getWildcard();
                        if (v.overlaps(w)) {
                            if ((union = union == null ? v : Wildcard.makeUnion(union, v, compiler.getNamePool())).isInexpressible()) {
                                return "The union of the wildcards in the base type that match a wildcard in the derived type is inexpressible";
                            }
                            unionMax = vp.getMaxOccurs() == -1 || unionMax == -1 ? -1 : (unionMax += vp.getMaxOccurs());
                            if (wp.getMaxOccurs() != -1) {
                                int n = counterIndex;
                                maxCounters[n] = maxCounters[n] + wp.getMaxOccurs();
                                int baseMax = vp.getMaxOccurs();
                                if (baseMax != -1 && maxCounters[counterIndex] > baseMax) {
                                    return "The derived type allows more occurrences (" + maxCounters[counterIndex] + ") of a wildcard than the base type allows (" + baseMax + ")";
                                }
                            }
                            if (v.compareStrength(w) > 0) {
                                return "A wildcard in the derived type has a less strict processContents than the corresponding wildcard in the base type";
                            }
                        }
                        if (w.isSubset(v, this.getConfiguration().getNamePool())) {
                            int n = counterIndex;
                            minCounters[n] = minCounters[n] + wp.getMinOccurs();
                        }
                        ++counterIndex;
                        continue;
                    }
                    if (!(baseParticle instanceof ElementParticle)) continue;
                    ElementParticle ep = (ElementParticle)baseParticle;
                    if (!wp.getWildcard().matches(ep.getTargetComponentName(), true, (Configuration)this.getConfiguration(), null)) continue;
                    boolean found = false;
                    for (Particle derivedParticle : derivedParticles) {
                        if (!(derivedParticle instanceof ElementParticle) || !derivedParticle.getTargetComponentName().equals(ep.getTargetComponentName())) continue;
                        found = true;
                    }
                    if (found || ep.getDeclaration().getType() == AnyType.getInstance()) continue;
                    return "The derived type contains a wildcard which matches elements named " + Err.wrap(ep.getDisplayName(), 1) + " but which allows element content that the element particle for " + Err.wrap(ep.getDisplayName(), 1) + " in the base type does not allow";
                }
                if (unionMax != -1) {
                    if (unionMax == 0) {
                        return "A wildcard in the derived type allows elements that are not permitted by the base type";
                    }
                    if (wp.getMaxOccurs() == -1) {
                        return "A wildcard in the derived type allows unlimited occurrences, but the base type imposes a limit";
                    }
                    if (wp.getMaxOccurs() > unionMax) {
                        return "A wildcard in the derived type allows more occurrences (" + wp.getMaxOccurs() + ") than the maximum allowed by the base type (" + unionMax + ")";
                    }
                }
                if (w.isSubset(union, compiler.getNamePool())) continue;
                return "A wildcard in the derived type allows elements that do not match any wildcard in the base type";
            }
            return "?A type derived by restriction from <xs:all> must only contain element particles and wildcard particles in its content model";
        }
        for (i = 0; i < baseParticles.size(); ++i) {
            int counterIndex;
            Particle p = baseParticles.get(i);
            if (!(p instanceof ElementParticle) || minCounters[counterIndex = this.counterMap.get(((ElementParticle)p).getDeclaration().getFingerprint())] >= p.getMinOccurs()) continue;
            String clarkName = p.getTargetComponentName().getDisplayName();
            if (minCounters[counterIndex] == 0) {
                if (maxCounters[counterIndex] == 0) {
                    return "Element " + Err.wrap(clarkName, 1) + " is mandatory in the base type, but is not permitted in the derived type";
                }
                return "Element " + Err.wrap(clarkName, 1) + " is mandatory in the base type, but is not mandatory in the derived type";
            }
            return "Element " + Err.wrap(clarkName, 1) + " allows a smaller number of occurrences (" + minCounters[i] + ") in the derived type than the minimum required by the base type (" + p.getMinOccurs() + ")";
        }
        if (this.wildcards != null) {
            for (i = 0; i < this.wildcards.size(); ++i) {
                if (minCounters[i] >= this.wildcards.get(i).getMinOccurs()) continue;
                if (minCounters[i] == 0) {
                    return "A wildcard is mandatory in the base type, but is not permitted in the derived type";
                }
                return "A wildcard in the base type allows a smaller number of occurrences (" + minCounters[i] + ") in the derived type than the minimum required by the base type (" + this.wildcards.get(i).getMinOccurs() + ")";
            }
        }
        return null;
    }

    private List<Particle> flattenParticleList(List<Particle> particles, int min, int max) throws MissingComponentException {
        if (min == 1 && max == 1) {
            boolean alreadyFlat = true;
            for (Particle p : particles) {
                if (!(p instanceof ModelGroupParticle)) continue;
                alreadyFlat = false;
                break;
            }
            if (alreadyFlat) {
                return particles;
            }
        }
        ArrayList<Particle> p2 = new ArrayList<Particle>();
        for (Particle p : particles) {
            Particle e2;
            if (p instanceof ModelGroupParticle) {
                ModelGroup group = (ModelGroup)p.getTarget();
                int newMin = min * p.getMinOccurs();
                if (group instanceof ChoiceModelGroup) {
                    newMin = 0;
                }
                int newMax = max == -1 || p.getMaxOccurs() == -1 ? -1 : max * p.getMaxOccurs();
                List<Particle> mp = this.flattenParticleList(group.getSimplifiedContentModel(), newMin, newMax);
                p2.addAll(mp);
                continue;
            }
            if (min == 1 && max == 1) {
                p2.add(p);
                continue;
            }
            if (p instanceof ElementParticle) {
                e2 = ((ElementParticle)p).copy();
                e2.setMinOccurs(p.getMinOccurs() * min);
                e2.setMaxOccurs(max == -1 || p.getMaxOccurs() == -1 ? -1 : p.getMaxOccurs() * max);
                p2.add(e2);
                continue;
            }
            if (!(p instanceof ElementWildcard)) continue;
            e2 = ((ElementWildcard)p).copy();
            e2.setMinOccurs(p.getMinOccurs() * min);
            e2.setMaxOccurs(max == -1 || p.getMaxOccurs() == -1 ? -1 : p.getMaxOccurs() * max);
            p2.add(e2);
        }
        return p2;
    }
}

